/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.mines.ExplosiveBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class FurnaceMineBlock
extends ExplosiveBlock
implements IOverlayDisplay,
IBlockMine {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public FurnaceMineBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (!world.field_72995_K) {
            if (player != null && player.func_184812_l_() && !((Boolean)ConfigHandler.CONFIG.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (player.field_71071_by.func_70448_g().func_77973_b() != SCContent.REMOTE_ACCESS_MINE.get() && !EntityUtils.doesPlayerOwn(player, world, pos)) {
            this.explode(world, pos);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
    }

    @Override
    public void explode(World world, BlockPos pos) {
        world.func_175655_b(pos, false);
        if (((Boolean)ConfigHandler.CONFIG.smallerMineExplosion.get()).booleanValue()) {
            world.func_217398_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 2.5f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
        } else {
            world.func_217398_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public ItemStack getDisplayStack(World world, BlockState state, BlockPos pos) {
        return new ItemStack((IItemProvider)Blocks.field_150460_al);
    }

    @Override
    public boolean shouldShowSCInfo(World world, BlockState state, BlockPos pos) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

