/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.tileentity.IMSTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class IMSBlock
extends OwnableBlock {
    public static final IntegerProperty MINES = IntegerProperty.func_177719_a((String)"mines", (int)0, (int)4);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)7.0, (double)11.0);
    private static final VoxelShape SHAPE_1_MINE = VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_2_MINES = VoxelShapes.func_197872_a((VoxelShape)SHAPE_1_MINE, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)5.0, (double)16.0));
    private static final VoxelShape SHAPE_3_MINES = VoxelShapes.func_197872_a((VoxelShape)SHAPE_2_MINES, (VoxelShape)Block.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_4_MINES = VoxelShapes.func_197872_a((VoxelShape)SHAPE_3_MINES, (VoxelShape)Block.func_208617_a((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0, (double)16.0));

    public IMSBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)MINES, (Comparable)Integer.valueOf(4)));
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_180647_a(state, player, world, pos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        switch ((Integer)state.func_177229_b((Property)MINES)) {
            case 4: {
                return SHAPE_4_MINES;
            }
            case 3: {
                return SHAPE_3_MINES;
            }
            case 2: {
                return SHAPE_2_MINES;
            }
            case 1: {
                return SHAPE_1_MINE;
            }
        }
        return SHAPE;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        world.func_175655_b(pos, true);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player)) {
            TileEntity te;
            ItemStack held = player.func_184586_b(hand);
            int mines = (Integer)state.func_177229_b((Property)MINES);
            if (held.func_77973_b() == ((Block)SCContent.BOUNCING_BETTY.get()).func_199767_j() && mines < 4) {
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)MINES, (Comparable)Integer.valueOf(mines + 1)));
                ((IMSTileEntity)world.func_175625_s(pos)).setBombsRemaining(mines + 1);
            } else if (player instanceof ServerPlayerEntity && (te = world.func_175625_s(pos)) instanceof INamedContainerProvider) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)MINES) == 0) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_195590_a((IParticleData)ParticleTypes.field_197601_L, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)ParticleTypes.field_197601_L, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)ParticleTypes.field_197601_L, false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)ParticleTypes.field_197601_L, false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)ParticleTypes.field_197601_L, false, x, y, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)ParticleTypes.field_197631_x, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)ParticleTypes.field_197631_x, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        int mines = (Integer)state.func_177229_b((Property)MINES);
        if (mines != 0) {
            return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)SCContent.BOUNCING_BETTY.get(), mines)});
        }
        return super.func_220076_a(state, builder);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)MINES, (Comparable)Integer.valueOf(4));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MINES});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new IMSTileEntity();
    }
}

