/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TrackMineTileEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.RailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class TrackMineBlock
extends RailBlock
implements IExplosive {
    public TrackMineBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            if (PlayerUtils.isHoldingItem(player, SCContent.REMOTE_ACCESS_MINE)) {
                return ActionResultType.SUCCESS;
            }
            if (this.isActive(world, pos) && this.isDefusable() && player.func_184586_b(hand).func_77973_b() == SCContent.WIRE_CUTTERS.get()) {
                this.defuseMine(world, pos);
                player.field_71071_by.func_70448_g().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (!this.isActive(world, pos) && PlayerUtils.isHoldingItem(player, Items.field_151033_d)) {
                this.activateMine(world, pos);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_180647_a(state, player, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public void onMinecartPass(BlockState state, World world, BlockPos pos, AbstractMinecartEntity cart) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineTileEntity && ((TrackMineTileEntity)te).isActive()) {
            world.func_175655_b(pos, false);
            world.func_217398_a((Entity)cart, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (Boolean)ConfigHandler.CONFIG.smallerMineExplosion.get() != false ? 4.0f : 8.0f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
            cart.func_70106_y();
        }
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175713_t(pos);
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineTileEntity && ((TrackMineTileEntity)te).isActive()) {
            world.func_175655_b(pos, false);
            world.func_217398_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p(), (Boolean)ConfigHandler.CONFIG.smallerMineExplosion.get() != false ? 4.0f : 8.0f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineTileEntity && !((TrackMineTileEntity)te).isActive()) {
            ((TrackMineTileEntity)te).activate();
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TrackMineTileEntity && ((TrackMineTileEntity)te).isActive()) {
            ((TrackMineTileEntity)te).deactivate();
        }
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TrackMineTileEntity && ((TrackMineTileEntity)te).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TrackMineTileEntity();
    }
}

