/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Map;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReinforcedPaneBlock
extends BaseReinforcedBlock
implements IBucketPickupHandler,
ILiquidContainer {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(entry -> ((Direction)entry.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    protected final VoxelShape[] field_196410_A = this.func_196408_a(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
    protected final VoxelShape[] field_196412_B = this.func_196408_a(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);

    public ReinforcedPaneBlock(AbstractBlock.Properties properties, Block vB) {
        super(properties, vB);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape[] func_196408_a(float p_196408_1_, float p_196408_2_, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - p_196408_1_;
        float f1 = 8.0f + p_196408_1_;
        float f2 = 8.0f - p_196408_2_;
        float f3 = 8.0f + p_196408_2_;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReader)world));
            }
            return true;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.field_196412_B[this.getIndex(state)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return this.field_196410_A[this.getIndex(state)];
    }

    private static int getMask(Direction facing) {
        return 1 << facing.func_176736_b();
    }

    protected int getIndex(BlockState p_196406_1_) {
        int i = 0;
        if (((Boolean)p_196406_1_.func_177229_b((Property)NORTH)).booleanValue()) {
            i |= ReinforcedPaneBlock.getMask(Direction.NORTH);
        }
        if (((Boolean)p_196406_1_.func_177229_b((Property)EAST)).booleanValue()) {
            i |= ReinforcedPaneBlock.getMask(Direction.EAST);
        }
        if (((Boolean)p_196406_1_.func_177229_b((Property)SOUTH)).booleanValue()) {
            i |= ReinforcedPaneBlock.getMask(Direction.SOUTH);
        }
        if (((Boolean)p_196406_1_.func_177229_b((Property)WEST)).booleanValue()) {
            i |= ReinforcedPaneBlock.getMask(Direction.WEST);
        }
        return i;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)EAST, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)WEST))).func_206870_a((Property)EAST, state.func_177229_b((Property)NORTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)EAST))).func_206870_a((Property)WEST, state.func_177229_b((Property)SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a((Property)NORTH, state.func_177229_b((Property)SOUTH))).func_206870_a((Property)SOUTH, state.func_177229_b((Property)NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a((Property)EAST, state.func_177229_b((Property)WEST))).func_206870_a((Property)WEST, state.func_177229_b((Property)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState getStateForPlacement(IBlockReader world, BlockPos pos) {
        FluidState fluidState = world.func_204610_c(pos);
        BlockPos northPos = pos.func_177978_c();
        BlockPos southPos = pos.func_177968_d();
        BlockPos westPos = pos.func_177976_e();
        BlockPos eastPos = pos.func_177974_f();
        BlockState northState = world.func_180495_p(northPos);
        BlockState southState = world.func_180495_p(southPos);
        BlockState westState = world.func_180495_p(westPos);
        BlockState eastState = world.func_180495_p(eastPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(this.canAttachTo(northState, northState.func_224755_d(world, northPos, Direction.SOUTH))))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(this.canAttachTo(southState, southState.func_224755_d(world, southPos, Direction.NORTH))))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(this.canAttachTo(westState, westState.func_224755_d(world, westPos, Direction.EAST))))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(this.canAttachTo(eastState, eastState.func_224755_d(world, eastPos, Direction.WEST))))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canAttachTo(facingState, facingState.func_224755_d((IBlockReader)world, facingPos, facing.func_176734_d())))) : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (adjacentBlockState.func_177230_c() == this) {
            if (!side.func_176740_k().func_176722_c()) {
                return true;
            }
            if (((Boolean)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(side))).booleanValue() && ((Boolean)adjacentBlockState.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(side.func_176734_d()))).booleanValue()) {
                return true;
            }
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public final boolean canAttachTo(BlockState p_220112_1_, boolean p_220112_2_) {
        Block block = p_220112_1_.func_177230_c();
        return !ReinforcedPaneBlock.func_220073_a((Block)block) && p_220112_2_ || block instanceof ReinforcedPaneBlock;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, vanillaState.func_177229_b((Property)PaneBlock.field_196409_a))).func_206870_a((Property)EAST, vanillaState.func_177229_b((Property)PaneBlock.field_196411_b))).func_206870_a((Property)WEST, vanillaState.func_177229_b((Property)PaneBlock.field_196414_y))).func_206870_a((Property)SOUTH, vanillaState.func_177229_b((Property)PaneBlock.field_196413_c))).func_206870_a((Property)WATERLOGGED, vanillaState.func_177229_b((Property)PaneBlock.field_204514_u));
    }
}

