/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.WallBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedWallBlock
extends WallBlock
implements IReinforcedBlock {
    private final Supplier<Block> vanillaBlockSupplier = () -> vanillaBlock;

    public ReinforcedWallBlock(AbstractBlock.Properties properties, Block vanillaBlock) {
        super(properties);
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlockSupplier.get();
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176256_a, vanillaState.func_177229_b((Property)field_176256_a))).func_206870_a((Property)field_235613_c_, vanillaState.func_177229_b((Property)field_235613_c_))).func_206870_a((Property)field_235612_b_, vanillaState.func_177229_b((Property)field_235612_b_))).func_206870_a((Property)field_235614_d_, vanillaState.func_177229_b((Property)field_235614_d_))).func_206870_a((Property)field_235615_e_, vanillaState.func_177229_b((Property)field_235615_e_))).func_206870_a((Property)field_235616_f_, vanillaState.func_177229_b((Property)field_235616_f_));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new OwnableTileEntity();
    }
}

