/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network;

import java.lang.reflect.Field;
import java.util.HashMap;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedSnowyDirtBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.EmptyRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraTileEntityRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemTileEntityRenderer;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcaseInventoryScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasswordScreen;
import net.geforcemods.securitycraft.screen.BriefcaseSetupScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasswordScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.EditSecretSignScreen;
import net.geforcemods.securitycraft.screen.IMSScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderSetupScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasswordScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.tileentity.SecretSignTileEntity;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="securitycraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
implements IProxy {
    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        String[] facings = new String[]{"east", "north", "south", "west"};
        String[] bools = new String[]{"true", "false"};
        ResourceLocation[] facingPoweredBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "keycard_reader"), new ResourceLocation("securitycraft", "keypad"), new ResourceLocation("securitycraft", "retinal_scanner")};
        ResourceLocation[] facingBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "projector"), new ResourceLocation("securitycraft", "username_logger")};
        ResourceLocation[] poweredBlocks = new ResourceLocation[]{new ResourceLocation("securitycraft", "laser_block")};
        String[] mines = new String[]{"coal_ore", "cobblestone", "diamond_ore", "dirt", "emerald_ore", "gravel", "gold_ore", "gilded_blackstone", "furnace", "iron_ore", "lapis_ore", "nether_gold_ore", "redstone_ore", "sand", "stone"};
        for (String facing : facings) {
            for (String string : bools) {
                for (ResourceLocation facingPoweredBlock : facingPoweredBlocks) {
                    ClientProxy.registerDisguisedModel(event, facingPoweredBlock, "facing=" + facing + ",powered=" + string);
                }
            }
            for (String string : facingBlocks) {
                ClientProxy.registerDisguisedModel(event, (ResourceLocation)string, "facing=" + facing);
            }
        }
        for (String bool : bools) {
            for (String string : poweredBlocks) {
                ClientProxy.registerDisguisedModel(event, (ResourceLocation)string, "powered=" + bool);
            }
        }
        ResourceLocation cageTrapRl = new ResourceLocation("securitycraft", "cage_trap");
        ResourceLocation invScanRL = new ResourceLocation("securitycraft", "inventory_scanner");
        ClientProxy.registerDisguisedModel(event, cageTrapRl, "deactivated=true");
        ClientProxy.registerDisguisedModel(event, cageTrapRl, "deactivated=false");
        for (String facing : facings) {
            ClientProxy.registerDisguisedModel(event, invScanRL, "facing=" + facing + ",horizontal=true");
            ClientProxy.registerDisguisedModel(event, invScanRL, "facing=" + facing + ",horizontal=false");
        }
        for (String mine : mines) {
            ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", mine.replace("_ore", "") + "_mine"), new ResourceLocation(mine));
        }
        ClientProxy.registerBlockMineModel(event, new ResourceLocation("securitycraft", "quartz_mine"), new ResourceLocation("nether_quartz_ore"));
    }

    private static void registerDisguisedModel(ModelBakeEvent event, ResourceLocation rl, String stateString) {
        ModelResourceLocation mrl = new ModelResourceLocation(rl, stateString);
        event.getModelRegistry().put(mrl, new DisguisableDynamicBakedModel(rl, (IBakedModel)event.getModelRegistry().get(mrl)));
    }

    private static void registerBlockMineModel(ModelBakeEvent event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModelRegistry().put(mineMrl, new BlockMineModel((IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(realBlockRl, "inventory")), (IBakedModel)event.getModelRegistry().get(mineMrl)));
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/left_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_active"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/right_inactive"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_left"));
            event.addSprite(new ResourceLocation("securitycraft", "entity/chest/christmas_right"));
        }
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        RenderType cutout = RenderType.func_228643_e_();
        RenderType cutoutMipped = RenderType.func_228641_d_();
        RenderType translucent = RenderType.func_228645_f_();
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.BLOCK_POCKET_MANAGER.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.BLOCK_POCKET_WALL.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.CAGE_TRAP.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.INVENTORY_SCANNER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.INVENTORY_SCANNER_FIELD.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.KEYCARD_READER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.KEYPAD.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.LASER_BLOCK.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.LASER_FIELD.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLACK_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BLUE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_BROWN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_CHAIN.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_COBWEB.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_CYAN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GLASS_PANE.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRASS_BLOCK.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GRAY_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_GREEN_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_HOPPER.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_ICE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_BARS.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_IRON_TRAPDOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LANTERN.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_SOUL_LANTERN.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_BLUE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIGHT_GRAY_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_LIME_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_MAGENTA_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_ORANGE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PINK_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_PURPLE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_RED_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_WHITE_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.REINFORCED_YELLOW_STAINED_GLASS_PANE.get()), (RenderType)translucent);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.RETINAL_SCANNER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.SCANNER_DOOR.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.TRACK_MINE.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.TROPHY_SYSTEM.get()), (RenderType)cutoutMipped);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.USERNAME_LOGGER.get()), (RenderType)cutout);
        RenderTypeLookup.setRenderLayer((Block)((Block)SCContent.PROJECTOR.get()), (RenderType)cutoutMipped);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeBouncingBetty, BouncingBettyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeImsBomb, IMSBombRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeSecurityCamera, EmptyRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeSentry, SentryRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SCContent.eTypeBullet, BulletRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeBlockPocketManager, BlockPocketManagerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeKeypadChest, KeypadChestTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeRetinalScanner, RetinalScannerTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeSecurityCamera, SecurityCameraTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeSecretSign, SecretSignTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeTrophySystem, TrophySystemTileEntityRenderer::new);
        ClientRegistry.bindTileEntityRenderer(SCContent.teTypeProjector, ProjectorTileEntityRenderer::new);
        ScreenManager.func_216911_a(SCContent.cTypeBlockReinforcer, BlockReinforcerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBriefcase, BriefcasePasswordScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBriefcaseInventory, BriefcaseInventoryScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBriefcaseSetup, BriefcaseSetupScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeCustomizeBlock, CustomizeBlockScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeDisguiseModule, DisguiseModuleScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeInventoryScanner, InventoryScannerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeKeypadFurnace, KeypadFurnaceScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeCheckPassword, CheckPasswordScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeSetPassword, SetPasswordScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeUsernameLogger, UsernameLoggerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeIMS, IMSScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeKeycardSetup, KeycardReaderSetupScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeKeyChanger, KeyChangerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeBlockPocketManager, BlockPocketManagerScreen::new);
        ScreenManager.func_216911_a(SCContent.cTypeProjector, ProjectorScreen::new);
        KeyBindings.init();
    }

    @Override
    public void tint() {
        HashMap<Object, Integer> toTint = new HashMap<Object, Integer>();
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class) || !field.getAnnotation(Reinforced.class).hasTint()) continue;
            try {
                toTint.put(((RegistryObject)field.get(null)).get(), field.getAnnotation(Reinforced.class).tint());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        boolean tintBlocks = (Boolean)ConfigHandler.CONFIG.reinforcedBlockTint.get();
        int noTint = 0xFFFFFF;
        int crystalQuartzTint = 1422242;
        int reinforcedCrystalQuartzTint = 946275;
        toTint.put(SCContent.BLOCK_POCKET_MANAGER.get(), reinforcedCrystalQuartzTint);
        toTint.put(SCContent.BLOCK_POCKET_WALL.get(), reinforcedCrystalQuartzTint);
        toTint.put(SCContent.CHISELED_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.put(SCContent.CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.put(SCContent.CRYSTAL_QUARTZ_PILLAR.get(), crystalQuartzTint);
        toTint.put(SCContent.CRYSTAL_QUARTZ_SLAB.get(), crystalQuartzTint);
        toTint.put(SCContent.STAIRS_CRYSTAL_QUARTZ.get(), crystalQuartzTint);
        toTint.forEach((block, tint) -> Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> {
            if (world == null || pos == null) {
                return tint;
            }
            if (block == SCContent.REINFORCED_GRASS_BLOCK.get() && !((Boolean)state.func_177229_b((Property)ReinforcedSnowyDirtBlock.field_196382_a)).booleanValue()) {
                if (tintIndex == 0) {
                    return tintBlocks ? tint : noTint;
                }
                int grassTint = BiomeColors.func_228358_a_((IBlockDisplayReader)world, (BlockPos)pos);
                return tintBlocks ? this.mixTints(grassTint, (int)tint) : grassTint;
            }
            if (tintBlocks) {
                return tint;
            }
            if (tint == reinforcedCrystalQuartzTint || tint == crystalQuartzTint) {
                return crystalQuartzTint;
            }
            return noTint;
        }, new Block[]{block}));
        toTint.forEach((item, tint) -> Minecraft.func_71410_x().getItemColors().func_199877_a((stack, tintIndex) -> {
            if (item == SCContent.REINFORCED_GRASS_BLOCK.get()) {
                if (tintIndex == 0) {
                    return tintBlocks ? tint : noTint;
                }
                int grassTint = GrassColors.func_77480_a((double)0.5, (double)1.0);
                return tintBlocks ? this.mixTints(grassTint, (int)tint) : grassTint;
            }
            if (tintBlocks) {
                return tint;
            }
            if (tint == reinforcedCrystalQuartzTint || tint == crystalQuartzTint) {
                return crystalQuartzTint;
            }
            return noTint;
        }, new IItemProvider[]{item}));
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> {
            Block blockFromItem;
            Block block = state.func_177230_c();
            if (block instanceof DisguisableBlock && (blockFromItem = Block.func_149634_a((Item)((DisguisableBlock)block).getDisguisedStack((IBlockReader)world, pos).func_77973_b())) != Blocks.field_150350_a && !(blockFromItem instanceof DisguisableBlock)) {
                return Minecraft.func_71410_x().func_184125_al().func_228054_a_(blockFromItem.func_176223_P(), world, pos, tintIndex);
            }
            return noTint;
        }, new Block[]{(Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.USERNAME_LOGGER.get()});
    }

    private int mixTints(int tint1, int tint2) {
        int red = tint1 >> 16 & 0xFF;
        int green = tint1 >> 8 & 0xFF;
        int blue = tint1 & 0xFF;
        red = (int)((float)red * ((float)(tint2 >> 16 & 0xFF) / 255.0f));
        green = (int)((float)green * ((float)(tint2 >> 8 & 0xFF) / 255.0f));
        blue = (int)((float)blue * ((float)(tint2 & 0xFF) / 255.0f));
        return ((red << 8) + green << 8) + blue;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void displayMRATGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new MineRemoteAccessToolScreen(stack));
    }

    @Override
    public void displaySRATGui(ItemStack stack, int viewDistance) {
        Minecraft.func_71410_x().func_147108_a((Screen)new SentryRemoteAccessToolScreen(stack, viewDistance));
    }

    @Override
    public void displayEditModuleGui(ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((Screen)new EditModuleScreen(stack));
    }

    @Override
    public void displayCameraMonitorGui(PlayerInventory inv, CameraMonitorItem item, CompoundNBT stackTag) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CameraMonitorScreen(inv, item, stackTag));
    }

    @Override
    public void displaySCManualGui() {
        Minecraft.func_71410_x().func_147108_a((Screen)new SCManualScreen());
    }

    @Override
    public void displayEditSecretSignGui(SecretSignTileEntity te) {
        Minecraft.func_71410_x().func_147108_a((Screen)new EditSecretSignScreen(te));
    }
}

