/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.tileentity.UsernameLoggerTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateLogger {
    private int x;
    private int y;
    private int z;
    private int i;
    private String username;
    private String uuid;
    private long timestamp;

    public UpdateLogger() {
    }

    public UpdateLogger(int x, int y, int z, int i, String username, String uuid, long timestamp) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.i = i;
        this.username = username;
        this.uuid = uuid;
        this.timestamp = timestamp;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.i);
        buf.func_180714_a(this.username);
        buf.func_180714_a(this.uuid);
        buf.writeLong(this.timestamp);
    }

    public void fromBytes(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.i = buf.readInt();
        this.username = buf.func_150789_c(0x1FFFFFFF);
        this.uuid = buf.func_150789_c(0x1FFFFFFF);
        this.timestamp = buf.readLong();
    }

    public static void encode(UpdateLogger message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static UpdateLogger decode(PacketBuffer packet) {
        UpdateLogger message = new UpdateLogger();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(UpdateLogger message, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateLogger.lambda$null$0(message, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleMessage(UpdateLogger message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
            int i = message.i;
            UsernameLoggerTileEntity te = (UsernameLoggerTileEntity)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(pos);
            if (te != null) {
                te.players[i] = message.username;
                te.uuids[i] = message.uuid;
                te.timestamps[i] = message.timestamp;
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(UpdateLogger message, Supplier ctx) {
        UpdateLogger.handleMessage(message, ctx);
    }
}

