/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeypadFurnaceBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.containers.KeypadFurnaceContainer;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.RequestTEOwnableUpdate;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class KeypadFurnaceTileEntity
extends AbstractFurnaceTileEntity
implements IPasswordProtected,
INamedContainerProvider,
IOwnable,
INameable,
IModuleInventory,
ICustomizable {
    private static final LazyOptional<IItemHandler> EMPTY_INVENTORY = LazyOptional.of(() -> new EmptyHandler());
    private LazyOptional<IItemHandler> insertOnlyHandler;
    private Owner owner = new Owner();
    private String passcode;
    private ITextComponent furnaceCustomName;
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public KeypadFurnaceTileEntity() {
        super(SCContent.teTypeKeypadFurnace, IRecipeType.field_222150_b);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.getName());
            tag.func_74778_a("ownerUUID", this.owner.getUUID());
        }
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (tag.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = new StringTextComponent(tag.func_74779_i("CustomName"));
        }
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        if (tag.func_74764_b("owner")) {
            this.owner.setOwnerName(tag.func_74779_i("owner"));
        }
        if (tag.func_74764_b("ownerUUID")) {
            this.owner.setOwnerUUID(tag.func_74779_i("ownerUUID"));
        }
        if (tag.func_74764_b("passcode")) {
            this.passcode = tag.func_74779_i("passcode");
        }
        if (this.hasCustomSCName()) {
            tag.func_74778_a("CustomName", this.furnaceCustomName.getString());
        }
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            SecurityCraft.channel.sendToServer((Object)new RequestTEOwnableUpdate(this.field_174879_c));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            BlockPos offsetPos = this.field_174879_c.func_177972_a(side);
            BlockState offsetState = this.field_145850_b.func_180495_p(offsetPos);
            for (IExtractionBlock extractionBlock : SecurityCraft.getRegisteredExtractionBlocks()) {
                if (offsetState.func_177230_c() != extractionBlock.getBlock()) continue;
                if (!extractionBlock.canExtract(this, this.field_145850_b, offsetPos, offsetState)) {
                    return EMPTY_INVENTORY.cast();
                }
                return super.getCapability(cap, side);
            }
            return this.getInsertOnlyHandler().cast();
        }
        return super.getCapability(cap, side);
    }

    private LazyOptional<IItemHandler> getInsertOnlyHandler() {
        if (this.insertOnlyHandler == null) {
            this.insertOnlyHandler = LazyOptional.of(() -> new InsertOnlyInvWrapper((IInventory)this));
        }
        return this.insertOnlyHandler;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (ItemStack)this.field_214012_a.get(slot);
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock((IBlockReader)this.func_145831_w(), this.func_174877_v()) instanceof KeypadFurnaceBlock) {
            KeypadFurnaceBlock.activate(this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeCheckPassword, windowId, KeypadFurnaceTileEntity.this.field_145850_b, KeypadFurnaceTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(((Block)SCContent.KEYPAD_FURNACE.get()).func_149739_a());
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeSetPassword, windowId, KeypadFurnaceTileEntity.this.field_145850_b, KeypadFurnaceTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(((Block)SCContent.KEYPAD_FURNACE.get()).func_149739_a());
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)new StringTextComponent("SecurityCraft"), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player, boolean isCodebreakerDisabled) {
        if (!isCodebreakerDisabled) {
            this.activate(player);
            return true;
        }
        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.KEYPAD_FURNACE.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public IIntArray getFurnaceData() {
        return this.field_214013_b;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new KeypadFurnaceContainer(windowId, this.field_145850_b, this.field_174879_c, inv, (IInventory)this, this.field_214013_b);
    }

    protected Container func_213906_a(int windowId, PlayerInventory inv) {
        return this.createMenu(windowId, inv, inv.field_70458_d);
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomSCName() ? this.getCustomSCName() : this.func_213907_g();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent(((Block)SCContent.KEYPAD_FURNACE.get()).func_149739_a());
    }

    @Override
    public ITextComponent getCustomSCName() {
        return this.furnaceCustomName;
    }

    @Override
    public void setCustomSCName(ITextComponent customName) {
        this.furnaceCustomName = customName;
    }

    @Override
    public boolean hasCustomSCName() {
        return this.furnaceCustomName != null && this.furnaceCustomName.getString() != null && !this.furnaceCustomName.getString().isEmpty();
    }

    @Override
    public boolean canBeNamed() {
        return true;
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.WHITELIST, ModuleType.BLACKLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }
}

