/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedButtonBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedLeverBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedPressurePlateBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadFurnaceTileEntity;
import net.geforcemods.securitycraft.tileentity.KeypadTileEntity;
import net.geforcemods.securitycraft.tileentity.PortableRadarTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockUtils {
    private static final List<Block> PRESSURE_PLATES = Arrays.asList((Block)SCContent.REINFORCED_STONE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_OAK_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_SPRUCE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_BIRCH_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_JUNGLE_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_ACACIA_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_DARK_OAK_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_CRIMSON_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_WARPED_PRESSURE_PLATE.get(), (Block)SCContent.REINFORCED_POLISHED_BLACKSTONE_PRESSURE_PLATE.get());
    private static final List<Block> BUTTONS = Arrays.asList((Block)SCContent.REINFORCED_STONE_BUTTON.get(), (Block)SCContent.REINFORCED_OAK_BUTTON.get(), (Block)SCContent.REINFORCED_SPRUCE_BUTTON.get(), (Block)SCContent.REINFORCED_BIRCH_BUTTON.get(), (Block)SCContent.REINFORCED_JUNGLE_BUTTON.get(), (Block)SCContent.REINFORCED_ACACIA_BUTTON.get(), (Block)SCContent.REINFORCED_DARK_OAK_BUTTON.get(), (Block)SCContent.REINFORCED_CRIMSON_BUTTON.get(), (Block)SCContent.REINFORCED_WARPED_BUTTON.get(), (Block)SCContent.REINFORCED_POLISHED_BLACKSTONE_BUTTON.get());

    public static boolean isSideSolid(IWorldReader world, BlockPos pos, Direction side) {
        return world.func_180495_p(pos).func_224755_d((IBlockReader)world, pos, side);
    }

    public static void updateAndNotify(World world, BlockPos pos, Block block, int delay, boolean shouldUpdate) {
        if (shouldUpdate) {
            world.func_205220_G_().func_205360_a(pos, (Object)block, delay);
        }
        world.func_195593_d(pos, block);
    }

    public static Block getBlock(IBlockReader world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c();
    }

    public static Block getBlock(World world, int x, int y, int z) {
        return world.func_180495_p(BlockUtils.toPos(x, y, z)).func_177230_c();
    }

    public static void setBlockProperty(World world, BlockPos pos, BooleanProperty property, boolean value) {
        BlockUtils.setBlockProperty(world, pos, property, value, false);
    }

    public static void setBlockProperty(World world, BlockPos pos, BooleanProperty property, boolean value, boolean retainOldTileEntity) {
        BlockState state = world.func_180495_p(pos);
        if (!state.func_235901_b_((Property)property)) {
            return;
        }
        if (retainOldTileEntity) {
            CompoundNBT modules = null;
            String password = "";
            Owner owner = null;
            int cooldown = -1;
            if (world.func_175625_s(pos) instanceof IModuleInventory) {
                modules = ((IModuleInventory)world.func_175625_s(pos)).writeModuleInventory(new CompoundNBT());
            }
            if (world.func_175625_s(pos) instanceof OwnableTileEntity && ((OwnableTileEntity)world.func_175625_s(pos)).getOwner() != null) {
                owner = ((OwnableTileEntity)world.func_175625_s(pos)).getOwner();
            }
            if (world.func_175625_s(pos) instanceof KeypadTileEntity && ((KeypadTileEntity)world.func_175625_s(pos)).getPassword() != null) {
                password = ((KeypadTileEntity)world.func_175625_s(pos)).getPassword();
            }
            if (world.func_175625_s(pos) instanceof KeypadFurnaceTileEntity && ((KeypadFurnaceTileEntity)world.func_175625_s(pos)).getPassword() != null) {
                password = ((KeypadFurnaceTileEntity)world.func_175625_s(pos)).getPassword();
            }
            if (world.func_175625_s(pos) instanceof KeypadChestTileEntity && ((KeypadChestTileEntity)world.func_175625_s(pos)).getPassword() != null) {
                password = ((KeypadChestTileEntity)world.func_175625_s(pos)).getPassword();
            }
            if (world.func_175625_s(pos) instanceof PortableRadarTileEntity && ((PortableRadarTileEntity)world.func_175625_s(pos)).getAttackCooldown() != 0) {
                cooldown = ((PortableRadarTileEntity)world.func_175625_s(pos)).getAttackCooldown();
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(value)));
            world.func_175690_a(pos, tileEntity);
            if (modules != null) {
                ((IModuleInventory)world.func_175625_s(pos)).readModuleInventory(modules);
            }
            if (owner != null) {
                ((OwnableTileEntity)world.func_175625_s(pos)).getOwner().set(owner);
            }
            if (!password.isEmpty() && world.func_175625_s(pos) instanceof KeypadTileEntity) {
                ((KeypadTileEntity)world.func_175625_s(pos)).setPassword(password);
            }
            if (!password.isEmpty() && world.func_175625_s(pos) instanceof KeypadFurnaceTileEntity) {
                ((KeypadFurnaceTileEntity)world.func_175625_s(pos)).setPassword(password);
            }
            if (!password.isEmpty() && world.func_175625_s(pos) instanceof KeypadChestTileEntity) {
                ((KeypadChestTileEntity)world.func_175625_s(pos)).setPassword(password);
            }
            if (cooldown != -1 && world.func_175625_s(pos) instanceof PortableRadarTileEntity) {
                ((PortableRadarTileEntity)world.func_175625_s(pos)).setAttackCooldown(cooldown);
            }
        } else {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)property, (Comparable)Boolean.valueOf(value)));
        }
    }

    public static void setBlockProperty(World world, BlockPos pos, IntegerProperty property, int value) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_235901_b_((Property)property)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)property, (Comparable)Integer.valueOf(value)));
        }
    }

    public static <T extends Comparable<T>> T getBlockProperty(World world, BlockPos pos, Property<T> property) {
        return (T)world.func_180495_p(pos).func_177229_b(property);
    }

    public static AxisAlignedBB fromBounds(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d6 = Math.min(x1, x2);
        double d7 = Math.min(y1, y2);
        double d8 = Math.min(z1, z2);
        double d9 = Math.max(x1, x2);
        double d10 = Math.max(y1, y2);
        double d11 = Math.max(z1, z2);
        return new AxisAlignedBB(d6, d7, d8, d9, d10, d11);
    }

    public static BlockPos toPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public static int[] fromPos(BlockPos pos) {
        return new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    public static boolean hasActiveSCBlockNextTo(World world, BlockPos pos) {
        TileEntity thisTile = world.func_175625_s(pos);
        return BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, (Block)SCContent.LASER_BLOCK.get(), true, (state, te) -> (Boolean)state.func_177229_b((Property)LaserBlock.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, (Block)SCContent.RETINAL_SCANNER.get(), true, (state, te) -> (Boolean)state.func_177229_b((Property)RetinalScannerBlock.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, (Block)SCContent.KEYPAD.get(), true, (state, te) -> (Boolean)state.func_177229_b((Property)KeypadBlock.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, (Block)SCContent.KEYCARD_READER.get(), true, (state, te) -> (Boolean)state.func_177229_b((Property)KeycardReaderBlock.POWERED)) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, (Block)SCContent.INVENTORY_SCANNER.get(), true, (state, te) -> ((InventoryScannerTileEntity)te).hasModule(ModuleType.REDSTONE) && ((InventoryScannerTileEntity)te).shouldProvidePower()) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, null, false, (state, te) -> PRESSURE_PLATES.contains(state.func_177230_c()) && (Boolean)state.func_177229_b((Property)ReinforcedPressurePlateBlock.field_176580_a) != false) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, null, false, (state, te) -> BUTTONS.contains(state.func_177230_c()) && (Boolean)state.func_177229_b((Property)ReinforcedButtonBlock.field_176584_b) != false) || BlockUtils.hasActiveSCBlockNextTo(world, pos, thisTile, (Block)SCContent.REINFORCED_LEVER.get(), true, (state, te) -> (Boolean)state.func_177229_b((Property)ReinforcedLeverBlock.field_176359_b));
    }

    private static boolean hasActiveSCBlockNextTo(World world, BlockPos pos, TileEntity te, Block block, boolean checkForBlock, BiFunction<BlockState, TileEntity, Boolean> extraCondition) {
        for (Direction dir : Direction.values()) {
            TileEntity offsetTe;
            BlockPos offsetPos = pos.func_177972_a(dir);
            BlockState offsetState = world.func_180495_p(offsetPos);
            if ((!checkForBlock || offsetState.func_177230_c() == block) && extraCondition.apply(offsetState, offsetTe = world.func_175625_s(offsetPos)).booleanValue()) {
                return ((IOwnable)offsetTe).getOwner().owns((IOwnable)te);
            }
            if (world.func_175651_c(offsetPos, dir) != 15 || offsetState.func_185897_m()) continue;
            for (Direction dirOffset : Direction.values()) {
                TileEntity offsetTe2;
                if (dirOffset.func_176734_d() == dir) continue;
                BlockPos newOffsetPos = offsetPos.func_177972_a(dirOffset);
                offsetState = world.func_180495_p(newOffsetPos);
                if (checkForBlock && offsetState.func_177230_c() != block) continue;
                if (offsetState.func_235901_b_((Property)BlockStateProperties.field_208158_K) && offsetState.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    Direction.Axis offsetAxis = dirOffset.func_176740_k();
                    Direction offsetFacing = (Direction)offsetState.func_177229_b((Property)BlockStateProperties.field_208157_J);
                    AttachFace offsetAttachFace = (AttachFace)offsetState.func_177229_b((Property)BlockStateProperties.field_208158_K);
                    switch (offsetAxis) {
                        case X: 
                        case Z: {
                            if (offsetAttachFace == AttachFace.WALL && dirOffset == offsetFacing) break;
                            return false;
                        }
                        case Y: {
                            if ((dirOffset != Direction.UP || offsetAttachFace == AttachFace.FLOOR) && (dirOffset != Direction.DOWN || offsetAttachFace == AttachFace.CEILING)) break;
                            return false;
                        }
                    }
                }
                if (!extraCondition.apply(offsetState, offsetTe2 = world.func_175625_s(newOffsetPos)).booleanValue()) continue;
                return ((IOwnable)offsetTe2).getOwner().owns((IOwnable)te);
            }
        }
        return false;
    }
}

