/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class GuiScreenTooltip
extends Screen {
    protected List<GuiTextLabel> labelList = new ArrayList<GuiTextLabel>();

    protected GuiScreenTooltip(ITextComponent titleIn) {
        super(titleIn);
    }

    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        for (GuiTextLabel label : this.labelList) {
            label.render(this, ms);
        }
        if (ModRPGHud.instance.settings.getBoolValue("enable_button_tooltip").booleanValue()) {
            this.drawTooltip(ms, mouseX, mouseY);
        }
    }

    private void drawTooltip(MatrixStack ms, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer fontRenderer = mc.field_71466_p;
        GuiScreenTooltip gui = null;
        if (!(mc.field_71462_r instanceof GuiScreenTooltip)) {
            return;
        }
        gui = (GuiScreenTooltip)mc.field_71462_r;
        boolean shouldRenderTooltip = false;
        GuiButtonTooltip button = null;
        for (int x = 0; x < this.field_230710_m_.size(); ++x) {
            Widget b = (Widget)this.field_230710_m_.get(x);
            if (b instanceof GuiButtonTooltip) {
                button = (GuiButtonTooltip)b;
            }
            if (button == null || !button.func_230449_g_()) continue;
            shouldRenderTooltip = true;
            break;
        }
        if (shouldRenderTooltip) {
            int posX = mouseX + 5;
            int posY = mouseY + 5;
            int totalWidth = 0;
            boolean reverseY = false;
            String[] tooltip = button.getTooltip();
            if (tooltip != null) {
                int id;
                int counter = 0;
                for (id = 0; id < tooltip.length; ++id) {
                    int width = fontRenderer.func_78256_a(tooltip[id]);
                    if (totalWidth < width) {
                        totalWidth = fontRenderer.func_78256_a(tooltip[id]);
                    }
                    ++counter;
                }
                if ((posX -= totalWidth / 2) + totalWidth + 10 > gui.field_230708_k_) {
                    posX -= posX + totalWidth + 10 - gui.field_230708_k_;
                }
                if (posX < 0) {
                    posX = 0;
                }
                if (posY + 3 + tooltip.length * 12 + 2 > gui.field_230709_l_) {
                    reverseY = true;
                }
                if (reverseY) {
                    GuiScreenTooltip.func_238467_a_((MatrixStack)ms, (int)posX, (int)(posY - 3 - tooltip.length * 12 - 2), (int)(posX + totalWidth + 10), (int)posY, (int)-1610612736);
                } else {
                    GuiScreenTooltip.func_238467_a_((MatrixStack)ms, (int)posX, (int)posY, (int)(posX + totalWidth + 10), (int)(posY + 3 + tooltip.length * 12 + 2), (int)-1610612736);
                }
                for (id = 0; id < tooltip.length; ++id) {
                    if (tooltip[id].isEmpty()) continue;
                    if (reverseY) {
                        AbstractGui.func_238476_c_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)tooltip[id], (int)(posX + 5), (int)(posY - 2 - 12 * (counter - id - 1) - 10), (int)0xBBBBBB);
                        continue;
                    }
                    AbstractGui.func_238476_c_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)tooltip[id], (int)(posX + 5), (int)(posY + 5 + 12 * id), (int)0xBBBBBB);
                }
            }
        }
    }

    public class GuiTextLabel {
        int x;
        int y;
        String text;

        public GuiTextLabel(int x, int y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }

        public void render(Screen gui, MatrixStack ms) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            AbstractGui.func_238476_c_((MatrixStack)ms, (FontRenderer)((GuiScreenTooltip)GuiScreenTooltip.this).field_230706_i_.field_71466_p, (String)this.text, (int)this.x, (int)this.y, (int)-1);
        }
    }
}

