/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.GuiScreenTooltip;
import net.spellcraftgaming.rpghud.gui.GuiSliderMod;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

public class GuiSettingsModColor
extends GuiScreenTooltip {
    private TextFieldWidget colorCodeField;
    private Screen parent;
    private String colorType;
    private int colorR;
    private int colorG;
    private int colorB;
    private int color;
    private String title = "";

    public GuiSettingsModColor(Screen parent, String color, ITextComponent titleIn) {
        super(titleIn);
        this.parent = parent;
        this.colorType = color;
        this.setColors();
        this.title = this.setTitle() + " " + I18n.func_135052_a((String)"gui.rpg.editor", (Object[])new Object[0]);
    }

    private String setTitle() {
        return I18n.func_135052_a((String)("name." + this.colorType), (Object[])new Object[0]);
    }

    private void setColors() {
        int color;
        this.color = color = ModRPGHud.instance.settings.getIntValue(this.colorType).intValue();
        this.colorR = color >> 16 & 0xFF;
        this.colorG = color >> 8 & 0xFF;
        this.colorB = color & 0xFF;
    }

    private void setSettingColor() {
        ModRPGHud.instance.settings.setSetting(this.colorType, this.color);
    }

    public void func_231160_c_() {
        int i;
        this.func_230480_a_((Widget)new GuiSliderMod(GuiSliderMod.EnumColor.RED, this.field_230708_k_ / 2 - 75, 40, this.colorR, 0.0f, 255.0f, 1.0f, slider -> slider.func_230982_a_(0.0, 0.0)));
        this.func_230480_a_((Widget)new GuiSliderMod(GuiSliderMod.EnumColor.GREEN, this.field_230708_k_ / 2 - 75, 65, this.colorG, 0.0f, 255.0f, 1.0f, slider -> slider.func_230982_a_(0.0, 0.0)));
        this.func_230480_a_((Widget)new GuiSliderMod(GuiSliderMod.EnumColor.BLUE, this.field_230708_k_ / 2 - 75, 90, this.colorB, 0.0f, 255.0f, 1.0f, slider -> slider.func_230982_a_(0.0, 0.0)));
        this.colorCodeField = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 74, 115, 147, 20, (ITextComponent)new TranslationTextComponent(Settings.intToHexString(this.color)));
        this.colorCodeField.func_146180_a(Settings.intToHexString(this.color));
        this.colorCodeField.func_146203_f(7);
        this.field_230705_e_.add(this.colorCodeField);
        String[] colorString = new String[]{"color.red", "color.pink", "color.brown", "color.white", "color.orange", "color.green", "color.purple", "color.blue", "color.aqua", "color.black", "color.grey", "color.yellow"};
        for (i = 0; i < 6; ++i) {
            this.func_230480_a_((Widget)new GuiButtonTooltip(10 + i, this.field_230708_k_ / 4 * 3 - 20, 40 + i * 20, 60, 20, (ITextComponent)new TranslationTextComponent(colorString[i]), button -> this.actionPerformed(button)));
        }
        for (i = 0; i < 6; ++i) {
            this.func_230480_a_((Widget)new GuiButtonTooltip(16 + i, this.field_230708_k_ / 4 * 3 + 60 - 20, 40 + i * 20, 60, 20, (ITextComponent)new TranslationTextComponent(colorString[i + 6]), button -> this.actionPerformed(button)));
        }
        this.func_230480_a_((Widget)new GuiButtonTooltip(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 6 + 168, 125, 20, (ITextComponent)new TranslationTextComponent("gui.done"), button -> {
            this.setSettingColor();
            this.field_230706_i_.func_147108_a(this.parent);
        }).setTooltip(I18n.func_135052_a((String)"tooltip.done", (Object[])new Object[0])));
        this.func_230480_a_((Widget)new GuiButtonTooltip(this.field_230708_k_ / 2 + 24, this.field_230709_l_ / 6 + 168, 75, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), button -> this.field_230706_i_.func_147108_a(this.parent)).setTooltip(I18n.func_135052_a((String)"tooltip.cancel", (Object[])new Object[0])));
    }

    protected void actionPerformed(Button b) {
        GuiButtonTooltip button = (GuiButtonTooltip)b;
        if (button.field_230693_o_) {
            if (button.id == 10) {
                this.setColorTo(0xC10000);
            } else if (button.id == 11) {
                this.setColorTo(16738740);
            } else if (button.id == 12) {
                this.setColorTo(9127187);
            } else if (button.id == 13) {
                this.setColorTo(0xF2F2F2);
            } else if (button.id == 14) {
                this.setColorTo(16745472);
            } else if (button.id == 15) {
                this.setColorTo(3916288);
            } else if (button.id == 16) {
                this.setColorTo(10748144);
            } else if (button.id == 17) {
                this.setColorTo(23490);
            } else if (button.id == 18) {
                this.setColorTo(65535);
            } else if (button.id == 19) {
                this.setColorTo(0x292929);
            } else if (button.id == 20) {
                this.setColorTo(0x8A8A8A);
            } else if (button.id == 21) {
                this.setColorTo(0xEEEE00);
            } else if (button.id == 250) {
                this.setSettingColor();
                this.field_230706_i_.func_147108_a(this.parent);
            } else if (button.id == 251) {
                this.field_230706_i_.func_147108_a(this.parent);
            }
        }
    }

    public void setColorTo(int color) {
        this.color = color;
        this.colorR = this.color >> 16 & 0xFF;
        ((GuiSliderMod)((Object)this.field_230710_m_.get((int)0))).sliderValue = (float)this.colorR / 255.0f;
        ((GuiSliderMod)((Object)this.field_230710_m_.get((int)0))).value = this.colorR;
        this.colorG = this.color >> 8 & 0xFF;
        ((GuiSliderMod)((Object)this.field_230710_m_.get((int)1))).sliderValue = (float)this.colorG / 255.0f;
        ((GuiSliderMod)((Object)this.field_230710_m_.get((int)1))).value = this.colorG;
        this.colorB = this.color & 0xFF;
        ((GuiSliderMod)((Object)this.field_230710_m_.get((int)2))).sliderValue = (float)this.colorB / 255.0f;
        ((GuiSliderMod)((Object)this.field_230710_m_.get((int)2))).value = this.colorB;
        this.colorCodeField.func_146180_a(Settings.intToHexString(this.color));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.colorCodeField.func_230999_j_()) {
            if (!this.colorCodeField.func_146179_b().startsWith("#")) {
                String s = "#" + this.colorCodeField.func_146179_b();
                if (this.colorCodeField.func_146179_b().length() >= 7) {
                    s = "#";
                    for (int i = 0; i < 6; ++i) {
                        s = s + this.colorCodeField.func_146179_b().charAt(i);
                    }
                }
                this.colorCodeField.func_146180_a(s);
            }
            if (this.colorCodeField.func_146179_b().length() == 7 && this.colorCodeField.func_146179_b().startsWith("#") && this.colorCodeField.func_146179_b().replace("#", "").matches("[0-9A-Fa-f]+")) {
                this.color = Integer.valueOf(this.colorCodeField.func_146179_b().replace("#", ""), 16);
                this.colorR = this.color >> 16 & 0xFF;
                ((GuiSliderMod)((Object)this.field_230710_m_.get((int)0))).sliderValue = (float)this.colorR / 255.0f;
                ((GuiSliderMod)((Object)this.field_230710_m_.get((int)0))).value = this.colorR;
                this.colorG = this.color >> 8 & 0xFF;
                ((GuiSliderMod)((Object)this.field_230710_m_.get((int)1))).sliderValue = (float)this.colorG / 255.0f;
                ((GuiSliderMod)((Object)this.field_230710_m_.get((int)1))).value = this.colorG;
                this.colorB = this.color & 0xFF;
                ((GuiSliderMod)((Object)this.field_230710_m_.get((int)2))).sliderValue = (float)this.colorB / 255.0f;
                ((GuiSliderMod)((Object)this.field_230710_m_.get((int)2))).value = this.colorB;
            }
            this.colorCodeField.func_146180_a(this.colorCodeField.func_146179_b().toUpperCase());
        } else {
            this.colorCodeField.func_146180_a(Settings.intToHexString(this.color));
            this.colorR = ((GuiSliderMod)((Object)this.field_230710_m_.get(0))).getValue();
            this.colorG = ((GuiSliderMod)((Object)this.field_230710_m_.get(1))).getValue();
            this.colorB = ((GuiSliderMod)((Object)this.field_230710_m_.get(2))).getValue();
            int color = (this.colorR << 16) + (this.colorG << 8) + this.colorB;
            if (color > 0xFFFFFF) {
                color = 0xFFFFFF;
            }
            if (color < 0) {
                color = 0;
            }
            this.color = color;
        }
        this.colorCodeField.func_146178_a();
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.colorCodeField.func_230999_j_()) {
            this.colorCodeField.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
            if (p_keyPressed_1_ == 28) {
                this.colorCodeField.func_146195_b(false);
            }
        }
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231048_c_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        for (IGuiEventListener child : this.field_230705_e_) {
            if (!(child instanceof GuiSliderMod)) continue;
            ((GuiSliderMod)child).dragging = false;
        }
        return super.func_231048_c_(p_231048_1_, p_231048_3_, p_231048_5_);
    }

    @Override
    public void func_230430_a_(MatrixStack ms, int mouseX, int mouseY, float partialTicks) {
        FontRenderer fontRenderer = this.field_230706_i_.field_71466_p;
        this.func_230446_a_(ms);
        AbstractGui.func_238471_a_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)this.title, (int)(this.field_230708_k_ / 2), (int)12, (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)I18n.func_135052_a((String)"color.red", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)31, (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)I18n.func_135052_a((String)"color.green", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)56, (int)-1);
        AbstractGui.func_238471_a_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)I18n.func_135052_a((String)"color.blue", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)81, (int)-1);
        this.colorCodeField.func_230431_b_(ms, mouseX, mouseY, partialTicks);
        AbstractGui.func_238471_a_((MatrixStack)ms, (FontRenderer)fontRenderer, (String)(I18n.func_135052_a((String)"gui.rpg.result", (Object[])new Object[0]) + ": " + Settings.intToHexString(this.color)), (int)(this.field_230708_k_ / 2), (int)141, (int)-1);
        super.func_230430_a_(ms, mouseX, mouseY, partialTicks);
        HudElement.drawCustomBar(this.field_230708_k_ / 2 - 75, 149, 150, 16, 100.0, 0, 0, this.color, HudElement.offsetColorPercent(this.color, 25), true);
    }
}

