/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class RenderOverlay {
    private ModRPGHud rpgHud = ModRPGHud.instance;
    private Minecraft mc = Minecraft.func_71410_x();

    public RenderOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent event) {
        RenderGameOverlayEvent.ElementType type = event.getType();
        switch (type) {
            case AIR: {
                if (this.shouldRenderVanilla(HudElementType.AIR)) break;
                event.setCanceled(true);
                break;
            }
            case ARMOR: {
                if (this.shouldRenderVanilla(HudElementType.ARMOR)) break;
                event.setCanceled(true);
                break;
            }
            case EXPERIENCE: {
                if (this.shouldRenderVanilla(HudElementType.EXPERIENCE)) break;
                event.setCanceled(true);
                break;
            }
            case FOOD: {
                if (this.shouldRenderVanilla(HudElementType.FOOD)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTH: {
                if (this.shouldRenderVanilla(HudElementType.HEALTH)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTHMOUNT: {
                if (this.shouldRenderVanilla(HudElementType.HEALTH_MOUNT)) break;
                event.setCanceled(true);
                break;
            }
            case HOTBAR: {
                if (this.shouldRenderVanilla(HudElementType.HOTBAR)) break;
                event.setCanceled(true);
                break;
            }
            case JUMPBAR: {
                if (this.shouldRenderVanilla(HudElementType.JUMP_BAR)) break;
                event.setCanceled(true);
                break;
            }
            case POTION_ICONS: {
                if (this.shouldRenderVanilla(HudElementType.STATUS_EFFECTS)) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case ALL: {
                this.renderOverlay(event.getMatrixStack(), event.getPartialTicks());
                break;
            }
            case AIR: {
                if (!this.preventEventType(HudElementType.AIR)) break;
                event.setCanceled(true);
                break;
            }
            case ARMOR: {
                if (!this.preventEventType(HudElementType.ARMOR)) break;
                event.setCanceled(true);
                break;
            }
            case EXPERIENCE: {
                if (!this.preventEventType(HudElementType.EXPERIENCE)) break;
                event.setCanceled(true);
                break;
            }
            case FOOD: {
                if (!this.preventEventType(HudElementType.FOOD)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTH: {
                if (!this.preventEventType(HudElementType.HEALTH)) break;
                event.setCanceled(true);
                break;
            }
            case HEALTHMOUNT: {
                if (!this.preventEventType(HudElementType.HEALTH_MOUNT)) break;
                event.setCanceled(true);
                break;
            }
            case HOTBAR: {
                if (!this.preventEventType(HudElementType.HOTBAR)) break;
                event.setCanceled(true);
                break;
            }
            case JUMPBAR: {
                if (!this.preventEventType(HudElementType.JUMP_BAR)) break;
                event.setCanceled(true);
                break;
            }
            case POTION_ICONS: {
                if (!this.preventEventType(HudElementType.STATUS_EFFECTS)) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onChatRender(RenderGameOverlayEvent.Chat event) {
        if (ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            event.setPosY(event.getPosY() - 22);
        }
    }

    private void renderOverlay(MatrixStack ms, float partialTicks) {
        this.drawElement(HudElementType.WIDGET, ms, partialTicks);
        this.drawElement(HudElementType.CLOCK, ms, partialTicks);
        this.drawElement(HudElementType.DETAILS, ms, partialTicks);
        this.drawElement(HudElementType.COMPASS, ms, partialTicks);
        this.drawElement(HudElementType.ENTITY_INSPECT, ms, partialTicks);
        if (!this.shouldRenderVanilla(HudElementType.HEALTH)) {
            this.drawElement(HudElementType.HEALTH, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.ARMOR)) {
            this.drawElement(HudElementType.ARMOR, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.FOOD)) {
            this.drawElement(HudElementType.FOOD, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.HEALTH_MOUNT)) {
            this.drawElement(HudElementType.HEALTH_MOUNT, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.AIR)) {
            this.drawElement(HudElementType.AIR, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.JUMP_BAR)) {
            this.drawElement(HudElementType.JUMP_BAR, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.EXPERIENCE)) {
            this.drawElement(HudElementType.EXPERIENCE, ms, partialTicks);
            this.drawElement(HudElementType.LEVEL, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.HOTBAR)) {
            this.drawElement(HudElementType.HOTBAR, ms, partialTicks);
        }
        if (!this.shouldRenderVanilla(HudElementType.STATUS_EFFECTS)) {
            this.drawElement(HudElementType.STATUS_EFFECTS, ms, partialTicks);
        }
    }

    private void drawElement(HudElementType type, MatrixStack ms, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type) && !this.preventElementRenderType(type)) {
            this.bind(AbstractGui.field_230665_h_);
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            this.rpgHud.getActiveHud().drawElement(type, (AbstractGui)this.mc.field_71456_v, ms, partialTicks, partialTicks, this.mc.func_228018_at_().func_198107_o(), this.mc.func_228018_at_().func_198087_p());
            RenderSystem.popMatrix();
        }
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean shouldRenderVanilla(HudElementType type) {
        return this.isVanillaElement(type) || this.forceRenderTypeVanilla(type);
    }

    private boolean forceRenderTypeVanilla(HudElementType type) {
        String id = "render_vanilla_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private boolean preventEventType(HudElementType type) {
        String id = "prevent_event_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    private void bind(ResourceLocation res) {
        this.mc.func_110434_K().func_110577_a(res);
    }

    private boolean isVanillaElement(HudElementType type) {
        return ModRPGHud.instance.getActiveHud().isVanillaElement(type);
    }
}

