/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.RESTClient;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import com.ringosham.translationmod.client.types.baidu.TranslateError;
import com.ringosham.translationmod.client.types.baidu.TranslateSuccess;
import com.ringosham.translationmod.common.ConfigManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class BaiduClient
extends RESTClient {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final int LANGUAGE_NOT_SUPPORTED = 100000;

    public BaiduClient() {
        super("https://fanyi-api.baidu.com/api/trans/vip/translate");
    }

    @Override
    public RequestResult translate(String message, Language from, Language to) {
        if (from.getBaiduCode() == null || to.getBaiduCode() == null) {
            return new RequestResult(100000, null, null, null);
        }
        HashMap<String, String> queryParam = new HashMap<String, String>();
        String encodedMessage = null;
        try {
            encodedMessage = URLEncoder.encode(message, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        queryParam.put("q", encodedMessage);
        queryParam.put("to", to.getBaiduCode());
        queryParam.put("from", from.getBaiduCode());
        queryParam.put("appid", (String)ConfigManager.config.baiduAppId.get());
        String salt = String.valueOf(System.currentTimeMillis());
        queryParam.put("salt", salt);
        queryParam.put("sign", this.sign((String)ConfigManager.config.baiduAppId.get(), message, salt, (String)ConfigManager.config.baiduKey.get()));
        RESTClient.Response response = this.sendRequest("POST", queryParam, "application/x-www-form-urlencoded");
        if (response.getResponseCode() == 200) {
            Gson gson = new Gson();
            JsonObject parse = (JsonObject)gson.fromJson(response.getEntity(), JsonObject.class);
            if (!parse.has("error_code")) {
                TranslateSuccess success = (TranslateSuccess)gson.fromJson(response.getEntity(), TranslateSuccess.class);
                Language sourceLang = LangManager.getInstance().findLanguageFromBaidu(success.getFrom());
                return new RequestResult(response.getResponseCode(), success.getTrans_result()[0].getDstDecoded(), sourceLang, to);
            }
            TranslateError error = (TranslateError)gson.fromJson(response.getEntity(), TranslateError.class);
            return new RequestResult(error.getError_code(), null, null, null);
        }
        return new RequestResult(response.getResponseCode(), null, null, null);
    }

    private String sign(String appid, String q, String salt, String key) {
        String rawSignString = appid + q + salt + key;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] rawSignBytes = rawSignString.getBytes(StandardCharsets.UTF_8);
            byte[] signBytes = digest.digest(rawSignBytes);
            char[] signChars = new char[signBytes.length * 2];
            int index = 0;
            for (byte b : signBytes) {
                signChars[index++] = hexDigits[b >>> 4 & 0xF];
                signChars[index++] = hexDigits[b & 0xF];
            }
            return new String(signChars);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

