/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.RESTClient;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import com.ringosham.translationmod.common.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class GoogleClient
extends RESTClient {
    private static boolean accessDenied = false;

    public GoogleClient() {
        super("https://translate.googleapis.com/translate_a/single");
    }

    public static boolean isAccessDenied() {
        return accessDenied;
    }

    @Override
    public RequestResult translate(String message, Language from, Language to) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        String encodedMessage = null;
        try {
            encodedMessage = URLEncoder.encode(message, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        queryParam.put("client", "gtx");
        queryParam.put("sl", from.getGoogleCode());
        queryParam.put("tl", to.getGoogleCode());
        queryParam.put("dt", "t");
        queryParam.put("q", encodedMessage);
        try {
            RESTClient.Response response = this.sendRequest("GET", queryParam, "application/json");
            if (response.getResponseCode() != 200) {
                if (response.getResponseCode() == 429) {
                    accessDenied = true;
                    Timeout timeout = new Timeout();
                    timeout.start();
                    return new RequestResult(429, "Access to Google Translate denied", null, null);
                }
                accessDenied = true;
                Log.logger.error(response.getEntity());
                return new RequestResult(411, "API call error", null, null);
            }
            String responseString = response.getEntity();
            Gson gson = new GsonBuilder().setLenient().create();
            JsonArray json = (JsonArray)gson.fromJson(responseString, JsonArray.class);
            Language detectedSource = LangManager.getInstance().findLanguageFromGoogle(json.get(2).getAsString());
            JsonArray lines = json.get(0).getAsJsonArray();
            StringBuilder stringBuilder = new StringBuilder();
            for (JsonElement sentenceObj : lines) {
                JsonArray sentence = sentenceObj.getAsJsonArray();
                stringBuilder.append(sentence.get(0).getAsString());
                stringBuilder.append(" ");
            }
            return new RequestResult(200, stringBuilder.toString(), detectedSource, to);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RequestResult(1, "Connection error", null, null);
        }
    }

    private static class Timeout
    extends Thread {
        private Timeout() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300000L);
                accessDenied = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

