/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.RESTClient;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import com.ringosham.translationmod.client.types.google.TranslateError;
import com.ringosham.translationmod.client.types.google.TranslateResponse;
import com.ringosham.translationmod.common.ConfigManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class GooglePaidClient
extends RESTClient {
    private static boolean disable = false;

    public GooglePaidClient() {
        super("https://translation.googleapis.com/language/translate/v2");
    }

    public static void setDisable() {
        disable = true;
    }

    public static boolean getDisable() {
        return disable;
    }

    @Override
    public RequestResult translate(String message, Language from, Language to) {
        HashMap<String, String> queryParam = new HashMap<String, String>();
        String encodedMessage = null;
        try {
            encodedMessage = URLEncoder.encode(message, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        queryParam.put("q", encodedMessage);
        queryParam.put("target", to.getGoogleCode());
        queryParam.put("format", "text");
        queryParam.put("key", (String)ConfigManager.config.googleKey.get());
        if (from != LangManager.getInstance().getAutoLang()) {
            queryParam.put("source", from.getGoogleCode());
        }
        RESTClient.Response response = this.sendRequest("GET", queryParam, "application/json");
        String responseString = response.getEntity();
        Gson gson = new Gson();
        if (response.getResponseCode() == 200) {
            TranslateResponse transResponse = (TranslateResponse)gson.fromJson(responseString, TranslateResponse.class);
            String translatedText = transResponse.getData().getTranslations()[0].getTranslatedText();
            Language sourceLang = LangManager.getInstance().findLanguageFromGoogle(transResponse.getData().getTranslations()[0].getDetectedSourceLanguage());
            if (sourceLang == null) {
                sourceLang = from;
            }
            return new RequestResult(200, translatedText, sourceLang, to);
        }
        if (response.getResponseCode() < 100) {
            return new RequestResult(response.getResponseCode(), response.getEntity(), null, null);
        }
        try {
            TranslateError error = (TranslateError)gson.fromJson(responseString, TranslateError.class);
            return new RequestResult(error.getError().getCode(), error.getError().getMessage(), null, null);
        }
        catch (JsonSyntaxException e) {
            return new RequestResult(2, "Unknown response: " + responseString, null, null);
        }
    }
}

