/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.google.gson.Gson;
import com.ringosham.translationmod.client.types.Language;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class LangManager {
    private static final ResourceLocation langLocation = new ResourceLocation("translationmod", "lang.json");
    private static LangManager instance;
    private static Language autoLang;
    private List<Language> languages = new ArrayList<Language>();

    private LangManager() {
    }

    public static LangManager getInstance() {
        if (instance == null) {
            instance = new LangManager();
            InputStream in = LangManager.class.getResourceAsStream("/assets/translationmod/lang.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            Gson gson = new Gson();
            Language[] langArray = (Language[])gson.fromJson((Reader)reader, Language[].class);
            LangManager.instance.languages = Arrays.asList(langArray);
        }
        return instance;
    }

    public Language findLanguageFromName(String name) {
        for (Language lang : this.languages) {
            if (!lang.getName().equals(name)) continue;
            return lang;
        }
        return null;
    }

    public Language findLanguageFromGoogle(String googleCode) {
        for (Language lang : this.languages) {
            if (!lang.getGoogleCode().equals(googleCode)) continue;
            return lang;
        }
        return null;
    }

    public Language findLanguageFromBaidu(String baiduCode) {
        for (Language lang : this.languages) {
            if (!lang.getBaiduCode().equals(baiduCode)) continue;
            return lang;
        }
        return null;
    }

    public List<Language> getAllLanguages() {
        return new ArrayList<Language>(this.languages);
    }

    public Language getAutoLang() {
        if (autoLang == null) {
            autoLang = this.findLanguageFromGoogle("auto");
        }
        return autoLang;
    }
}

