/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public abstract class RESTClient {
    protected final String baseUrl;

    protected RESTClient(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public RequestResult translateAuto(String message, Language to) {
        return this.translate(message, LangManager.getInstance().getAutoLang(), to);
    }

    public abstract RequestResult translate(String var1, Language var2, Language var3);

    protected Response sendRequest(String method, Map<String, String> queryParams, String contentType) {
        StringBuilder requestUrl = new StringBuilder(this.baseUrl);
        boolean firstParam = true;
        for (String key : queryParams.keySet()) {
            if (firstParam) {
                requestUrl.append("?");
                firstParam = false;
            } else {
                requestUrl.append("&");
            }
            requestUrl.append(key).append("=").append(queryParams.get(key));
        }
        try {
            String line;
            URL request = new URL(requestUrl.toString());
            HttpsURLConnection connection = (HttpsURLConnection)request.openConnection();
            connection.setRequestProperty("Content-Type", contentType);
            connection.setDoOutput(true);
            connection.setRequestMethod(method);
            connection.setConnectTimeout(5000);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                String line2;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                StringBuilder responseString = new StringBuilder();
                while ((line2 = reader.readLine()) != null) {
                    responseString.append(line2);
                }
                return new Response(connection.getResponseCode(), responseString.toString());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8));
            StringBuilder responseString = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseString.append(line);
            }
            return new Response(connection.getResponseCode(), responseString.toString());
        }
        catch (MalformedURLException ignored) {
            return null;
        }
        catch (IOException e) {
            return new Response(1, "Failed to connect to server");
        }
    }

    public static class Response {
        private final int responseCode;
        private final String entity;

        public Response(int responseCode, String entity) {
            this.responseCode = responseCode;
            this.entity = entity;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getEntity() {
            return this.entity;
        }
    }
}

