/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.common;

import com.google.common.primitives.Ints;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigManager {
    public static final ClientConfig config;
    public static final ForgeConfigSpec configSpec;
    public static final String[] defaultRegex;
    public static final int[] defaultGroups;
    private static final String[] engines;
    private static final int configMinVersion = 1;

    public static void validateConfig() {
        ConfigManager.versionCheck();
        boolean valid = true;
        List regexList = (List)ConfigManager.config.regexList.get();
        List groupList = (List)ConfigManager.config.groupList.get();
        Iterator regexIt = regexList.iterator();
        int index = 0;
        while (regexIt.hasNext()) {
            String regex = (String)regexIt.next();
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                valid = false;
                regexIt.remove();
                groupList.remove(index);
                --index;
            }
            if ((Integer)groupList.get(index) <= 0) {
                valid = false;
                regexIt.remove();
                groupList.remove(index);
                --index;
            }
            ++index;
        }
        ArrayList colors = new ArrayList(TextFormatting.func_96296_a((boolean)true, (boolean)false));
        if (!colors.contains(ConfigManager.config.color.get())) {
            ConfigManager.config.color.set((Object)"gray");
            valid = false;
        }
        if (!valid) {
            ConfigManager.config.regexList.set((Object)regexList);
            ConfigManager.config.groupList.set((Object)groupList);
            ConfigManager.saveConfig();
        }
    }

    private static void versionCheck() {
        int configVersion = (Integer)ConfigManager.config.configMinVersion.get();
        if (1 > configVersion) {
            ConfigManager.config.targetLanguage.set((Object)"English");
            ConfigManager.config.selfLanguage.set((Object)"English");
            ConfigManager.config.speakAsLanguage.set((Object)"Japanese");
            ConfigManager.config.bold.set((Object)false);
            ConfigManager.config.italic.set((Object)false);
            ConfigManager.config.underline.set((Object)false);
            ConfigManager.config.translateSign.set((Object)true);
            ConfigManager.config.color.set((Object)"gray");
            ConfigManager.config.regexList.set(Arrays.asList(defaultRegex));
            ConfigManager.config.groupList.set((Object)Ints.asList((int[])defaultGroups));
            ConfigManager.config.configMinVersion.set((Object)1);
            ConfigManager.config.translationEngine.set((Object)engines[0]);
        }
    }

    public static void saveConfig() {
        configSpec.save();
        ConfigManager.config.selfLanguage.save();
        ConfigManager.config.targetLanguage.save();
        ConfigManager.config.speakAsLanguage.save();
        ConfigManager.config.groupList.save();
        ConfigManager.config.regexList.save();
        ConfigManager.config.bold.save();
        ConfigManager.config.italic.save();
        ConfigManager.config.underline.save();
        ConfigManager.config.color.save();
        ConfigManager.config.configMinVersion.save();
        ConfigManager.config.googleKey.save();
        ConfigManager.config.translateSign.save();
        ConfigManager.config.baiduKey.save();
        ConfigManager.config.baiduAppId.save();
        ConfigManager.config.translationEngine.save();
        ConfigManager.validateConfig();
    }

    static {
        defaultRegex = new String[]{"<(\\w+)> ", "\\(From (\\w+)\\):( )?", "(\\w+) whispers ", "(\\[\\S+\\]( )?){0,2}(\\w+)( )?\u00bb( )?", "(\\[\\S+\\]( )?){0,2}(\\w+)( )?:( )?(Eye\\[\\d\\] )?", "\\d{1,3} (\\w+ )?(\\w+) ", "Dead (\\d+ )?(\\w+ )?(\\w+) ", "(\\w+) > \\w+ ", "(\\w+) whispers to you: ", "(\\(Team\\) )?(\\[\\w+\\] ){1,2}(\\w+): ", "(\\w+ )?\\w+: (\\w+) > ", "\\[Lvl \\d+\\] \u25b6 (\\w+: )?(\\w+) > ", "\u25b6 \\[\\d+\\] (\\w+: )?(\\w+) > ", "\u25b6 (\\w+: )?(\\w+) > ", "(\\[\\w+\\])?\\[Level \\d+\\] \\[(\\w+)\\] ", "(\\w+) tells you: ", "\\[(\\w+) -> \\w+\\] ", "(\\w+ )?(\\w+-)?(\\w+)(\\*)?(\\+){0,2}:"};
        defaultGroups = new int[]{1, 1, 1, 3, 3, 2, 3, 1, 1, 3, 2, 2, 2, 2, 2, 1, 1, 3};
        engines = new String[]{"google", "baidu"};
        Pair pair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        configSpec = (ForgeConfigSpec)pair.getRight();
        config = (ClientConfig)pair.getLeft();
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.ConfigValue<String> targetLanguage;
        public final ForgeConfigSpec.ConfigValue<String> selfLanguage;
        public final ForgeConfigSpec.ConfigValue<String> speakAsLanguage;
        public final ForgeConfigSpec.BooleanValue bold;
        public final ForgeConfigSpec.BooleanValue italic;
        public final ForgeConfigSpec.BooleanValue underline;
        public final ForgeConfigSpec.ConfigValue<String> color;
        public final ForgeConfigSpec.BooleanValue translateSign;
        public final ForgeConfigSpec.ConfigValue<String> googleKey;
        public final ForgeConfigSpec.ConfigValue<List<String>> regexList;
        public final ForgeConfigSpec.ConfigValue<List<Integer>> groupList;
        public final ForgeConfigSpec.ConfigValue<String> baiduAppId;
        public final ForgeConfigSpec.ConfigValue<String> baiduKey;
        public final ForgeConfigSpec.ConfigValue<String> translationEngine;
        final ForgeConfigSpec.IntValue configMinVersion;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Real time translation mod configs").push("translationmod");
            this.configMinVersion = builder.comment("Config version. DO NOT CHANGE.").defineInRange("configMinVersion", 1, 0, Integer.MAX_VALUE);
            this.targetLanguage = builder.comment("Target language to translate for the chat").define("targetLanguage", (Object)"English", lang -> this.validateLang((String)lang));
            this.selfLanguage = builder.comment("The language the user types").define("selfLanguage", (Object)"English", lang -> this.validateLang((String)lang));
            this.speakAsLanguage = builder.comment("The language the user wants their message to translate to").define("speakAsLanguage", (Object)"Japanese", lang -> this.validateLang((String)lang));
            this.bold = builder.comment("Bold the translated message").define("bold", false);
            this.italic = builder.comment("Italic the translated message").define("italic", false);
            this.underline = builder.comment("Underline the translated message").define("underline", false);
            this.color = builder.comment("Changes the color of the translated message").define("color", (Object)"gray", color -> {
                ArrayList colors = new ArrayList(TextFormatting.func_96296_a((boolean)true, (boolean)false));
                String c = (String)color;
                return colors.contains(c);
            });
            this.translateSign = builder.comment("Allows translating texts in sign by looking").define("translateSign", true);
            this.googleKey = builder.comment("Your Google Cloud translation API key").define("googleKey", (Object)"");
            this.regexList = builder.comment("Your regex list").define("regexList", Arrays.asList(defaultRegex), o -> true);
            this.groupList = builder.comment("Your match group number to detect player names").define("groupList", (Object)Ints.asList((int[])defaultGroups), o -> true);
            this.baiduAppId = builder.comment("Your Baidu developer App ID").define("baiduAppId", (Object)"");
            this.baiduKey = builder.comment("Your Baidu API key").define("baiduKey", (Object)"");
            this.translationEngine = builder.comment("Translation engine used").define("translationEngine", (Object)"google", o -> {
                String value = (String)o;
                return Arrays.asList(engines).contains(value);
            });
        }

        private boolean validateLang(String lang) {
            if (lang == null) {
                return false;
            }
            List<Language> languages = LangManager.getInstance().getAllLanguages();
            for (Language language : languages) {
                if (!lang.equals(language.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

