/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.EngineGui;
import com.ringosham.translationmod.gui.LanguageSelectGui;
import com.ringosham.translationmod.gui.RegexGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class ConfigGui
extends CommonGui {
    private static final int guiWidth = 250;
    private static final int guiHeight = 206;
    private static final StringTextComponent targetTooltip = new StringTextComponent("The language your chat will be translated to");
    private static final List<ITextComponent> selfTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> speakAsTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> regexTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> apiKeyTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> colorTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> boldTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> underlineTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> italicTooltip = new ArrayList<ITextComponent>();
    private static final List<ITextComponent> signTooltip = new ArrayList<ITextComponent>();
    private static final String title;
    private boolean isTransition = false;
    private Language targetLang;
    private Language speakAsLang;
    private Language selfLang;
    private String color;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean translateSign;

    ConfigGui() {
        super(title, 206, 250);
    }

    ConfigGui(ConfigGui instance, int langSelect, Language lang) {
        super(title, 206, 250);
        this.targetLang = instance.targetLang;
        this.speakAsLang = instance.speakAsLang;
        this.selfLang = instance.selfLang;
        this.color = instance.color;
        this.bold = instance.bold;
        this.italic = instance.italic;
        this.underline = instance.underline;
        this.translateSign = instance.translateSign;
        this.isTransition = true;
        if (lang != null) {
            switch (langSelect) {
                case 0: {
                    this.targetLang = lang;
                    break;
                }
                case 1: {
                    this.selfLang = lang;
                    break;
                }
                case 2: {
                    this.speakAsLang = lang;
                }
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int x, int y, float tick) {
        super.func_230430_a_(stack, x, y, tick);
        this.drawStringLine(stack, title, null, 0);
        this.field_230712_o_.func_238421_b_(stack, "Regex list:", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 25), 0x555555);
        this.field_230712_o_.func_238421_b_(stack, "Target language:", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 55), 0x555555);
        this.field_230712_o_.func_238421_b_(stack, "Self language:", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 75), 0x555555);
        this.field_230712_o_.func_238421_b_(stack, "Speak as language:", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 95), 0x555555);
        this.field_230712_o_.func_238421_b_(stack, "Preview: ", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 115), 0x555555);
        Style previewStyle = Style.field_240709_b_.func_240712_a_(TextFormatting.func_96300_b((String)this.color)).func_240717_a_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(this.bold))).func_240717_a_(Style.field_240709_b_.func_240722_b_(Boolean.valueOf(this.italic))).func_240717_a_(Style.field_240709_b_.setUnderlined(Boolean.valueOf(this.underline)));
        this.field_230712_o_.func_243248_b(stack, (ITextComponent)new StringTextComponent("Notch --> English: Hello!").func_230530_a_(previewStyle), (float)(this.getLeftMargin() + 45), (float)(this.getYOrigin() + 115), 0);
        if (((Widget)this.field_230710_m_.get(2)).func_230449_g_()) {
            this.func_238652_a_(stack, (ITextComponent)targetTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(3)).func_230449_g_()) {
            this.func_243308_b(stack, selfTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(4)).func_230449_g_()) {
            this.func_243308_b(stack, speakAsTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(11)).func_230449_g_()) {
            this.func_243308_b(stack, regexTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(6)).func_230449_g_()) {
            this.func_243308_b(stack, apiKeyTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(5)).func_230449_g_()) {
            this.func_243308_b(stack, signTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(7)).func_230449_g_()) {
            this.func_243308_b(stack, colorTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(8)).func_230449_g_()) {
            this.func_243308_b(stack, boldTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(9)).func_230449_g_()) {
            this.func_243308_b(stack, italicTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(10)).func_230449_g_()) {
            this.func_243308_b(stack, underlineTooltip, x, y);
        }
    }

    public void func_231160_c_() {
        if (!this.isTransition) {
            this.color = (String)ConfigManager.config.color.get();
            this.bold = (Boolean)ConfigManager.config.bold.get();
            this.italic = (Boolean)ConfigManager.config.italic.get();
            this.underline = (Boolean)ConfigManager.config.underline.get();
            this.translateSign = (Boolean)ConfigManager.config.translateSign.get();
            this.targetLang = LangManager.getInstance().findLanguageFromName((String)ConfigManager.config.targetLanguage.get());
            this.selfLang = LangManager.getInstance().findLanguageFromName((String)ConfigManager.config.selfLanguage.get());
            this.speakAsLang = LangManager.getInstance().findLanguageFromName((String)ConfigManager.config.speakAsLanguage.get());
        }
        this.func_230480_a_((Widget)new Button(this.getLeftMargin(), this.getYOrigin() + 206 - 5 - 20, 100, 20, (ITextComponent)new StringTextComponent("Save and close"), button -> this.applySettings()));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 206 - 5 - 20, 100, 20, (ITextComponent)new StringTextComponent("Reset to default"), button -> this.resetDefault()));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 50, 100, 20, (ITextComponent)new StringTextComponent(this.targetLang.getName()), button -> this.langSelect(0)));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 70, 100, 20, (ITextComponent)new StringTextComponent(this.selfLang.getName()), button -> this.langSelect(1)));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 90, 100, 20, (ITextComponent)new StringTextComponent(this.speakAsLang.getName()), button -> this.langSelect(2)));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin(), this.getYOrigin() + 206 - 15 - 60, 100, 20, (ITextComponent)new StringTextComponent(this.translateSign ? TextFormatting.GREEN + "Translate signs" : TextFormatting.RED + "Translate signs"), button -> {
            this.translateSign = !this.translateSign;
            this.toggleButtonBool(this.translateSign, button);
        }));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin(), this.getYOrigin() + 206 - 10 - 40, 100, 20, (ITextComponent)new StringTextComponent("Engine options"), button -> this.addKeyGui()));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 206 - 10 - 40, 100, 20, (ITextComponent)new StringTextComponent(TextFormatting.func_96300_b((String)this.color) + "Message color"), this::rotateColor));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin() + 100 + 10, this.getYOrigin() + 206 - 15 - 60, 20, 20, (ITextComponent)new StringTextComponent(this.bold ? "\u00a7a" + TextFormatting.BOLD + "B" : "\u00a7c" + TextFormatting.BOLD + "B"), button -> {
            this.bold = !this.bold;
            this.toggleButtonBool(this.bold, button, TextFormatting.BOLD);
        }));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin() + 100 + 10, this.getYOrigin() + 206 - 10 - 40, 20, 20, (ITextComponent)new StringTextComponent(this.italic ? "\u00a7a" + TextFormatting.ITALIC + "I" : "\u00a7c" + TextFormatting.ITALIC + "I"), button -> {
            this.italic = !this.italic;
            this.toggleButtonBool(this.italic, button, TextFormatting.ITALIC);
        }));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin() + 100 + 10, this.getYOrigin() + 206 - 5 - 20, 20, 20, (ITextComponent)new StringTextComponent(this.underline ? "\u00a7a" + TextFormatting.UNDERLINE + "U" : "\u00a7c" + TextFormatting.UNDERLINE + "U"), button -> {
            this.underline = !this.underline;
            this.toggleButtonBool(this.underline, button, TextFormatting.UNDERLINE);
        }));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 20, 100, 20, (ITextComponent)new StringTextComponent("View / Add"), button -> this.regexGui()));
    }

    private void applySettings() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
        ConfigManager.config.targetLanguage.set((Object)this.targetLang.getName());
        ConfigManager.config.selfLanguage.set((Object)this.selfLang.getName());
        ConfigManager.config.speakAsLanguage.set((Object)this.speakAsLang.getName());
        ConfigManager.config.color.set((Object)this.color);
        ConfigManager.config.bold.set((Object)this.bold);
        ConfigManager.config.italic.set((Object)this.italic);
        ConfigManager.config.underline.set((Object)this.underline);
        ConfigManager.config.translateSign.set((Object)this.translateSign);
        ConfigManager.saveConfig();
        ChatUtil.printChatMessage(true, "Settings applied.", TextFormatting.WHITE);
        this.exitGui();
    }

    private void exitGui() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
        this.getMinecraft().func_147108_a(null);
    }

    private void langSelect(int id) {
        this.getMinecraft().func_147108_a((Screen)new LanguageSelectGui(this, id));
    }

    private void toggleButtonBool(boolean state, Button button, TextFormatting prefixFormat) {
        String rawString = button.func_230458_i_().func_150261_e().replaceAll("\u00a7(.)", "");
        TextFormatting color = state ? TextFormatting.GREEN : TextFormatting.RED;
        StringTextComponent buttonText = prefixFormat == null ? new StringTextComponent(color + rawString) : new StringTextComponent(prefixFormat + "" + color + rawString);
        button.func_238482_a_((ITextComponent)buttonText);
    }

    private void toggleButtonBool(boolean state, Button button) {
        this.toggleButtonBool(state, button, null);
    }

    private void rotateColor(Button button) {
        TextFormatting formatColor = TextFormatting.func_96300_b((String)this.color);
        int colorCode = formatColor.func_175746_b();
        ++colorCode;
        TextFormatting newColor = TextFormatting.func_175744_a((int)(colorCode &= 0xF));
        this.color = newColor.func_96297_d();
        StringTextComponent buttonText = new StringTextComponent(newColor + button.func_230458_i_().func_150261_e().replaceAll("\u00a7(.)", ""));
        button.func_238482_a_((ITextComponent)buttonText);
    }

    private void regexGui() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.getMinecraft().func_147108_a((Screen)new RegexGui());
    }

    private void addKeyGui() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.getMinecraft().func_147108_a((Screen)new EngineGui());
    }

    private void resetDefault() {
        this.color = "gray";
        this.bold = false;
        this.italic = false;
        this.underline = false;
        this.translateSign = true;
        this.selfLang = this.targetLang = LangManager.getInstance().findLanguageFromName("English");
        this.speakAsLang = LangManager.getInstance().findLanguageFromName("Japanese");
        ((Widget)this.field_230710_m_.get(2)).func_238482_a_((ITextComponent)new StringTextComponent("English"));
        ((Widget)this.field_230710_m_.get(3)).func_238482_a_((ITextComponent)new StringTextComponent("English"));
        ((Widget)this.field_230710_m_.get(4)).func_238482_a_((ITextComponent)new StringTextComponent("Japanese"));
        ((Widget)this.field_230710_m_.get(5)).func_238482_a_((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Translate signs"));
        ((Widget)this.field_230710_m_.get(7)).func_238482_a_((ITextComponent)new StringTextComponent(TextFormatting.func_96300_b((String)this.color) + "Message color"));
        ((Widget)this.field_230710_m_.get(8)).func_238482_a_((ITextComponent)new StringTextComponent(this.bold ? "\u00a7a" : "\u00a7c" + TextFormatting.BOLD + "B"));
        ((Widget)this.field_230710_m_.get(9)).func_238482_a_((ITextComponent)new StringTextComponent(this.italic ? "\u00a7a" : "\u00a7c" + TextFormatting.ITALIC + "I"));
        ((Widget)this.field_230710_m_.get(10)).func_238482_a_((ITextComponent)new StringTextComponent(this.underline ? "\u00a7a" : "\u00a7c" + TextFormatting.UNDERLINE + "U"));
    }

    static {
        selfTooltip.add((ITextComponent)new StringTextComponent("The language you speak in game"));
        selfTooltip.add((ITextComponent)new StringTextComponent("This will be utilised when you want to translate what you speak"));
        speakAsTooltip.add((ITextComponent)new StringTextComponent("The language your messages will be translated to."));
        speakAsTooltip.add((ITextComponent)new StringTextComponent("After you typed your messages through this mod,"));
        speakAsTooltip.add((ITextComponent)new StringTextComponent("it will be translated to the language you specified"));
        regexTooltip.add((ITextComponent)new StringTextComponent("Regex are patterns for the mod to detect chat messages."));
        regexTooltip.add((ITextComponent)new StringTextComponent("If you notice the mod doesn't do anything on a server,"));
        regexTooltip.add((ITextComponent)new StringTextComponent("chances are you need to add one here."));
        signTooltip.add((ITextComponent)new StringTextComponent("Translates signs when you look at them"));
        apiKeyTooltip.add((ITextComponent)new StringTextComponent("Change your translation engine options and enter your API key"));
        colorTooltip.add((ITextComponent)new StringTextComponent("Changes the color of the translated message"));
        boldTooltip.add((ITextComponent)new StringTextComponent("Bolds the translated message"));
        italicTooltip.add((ITextComponent)new StringTextComponent("Italics the translated message"));
        underlineTooltip.add((ITextComponent)new StringTextComponent("Underlines the translated message"));
        String modName = ((ModContainer)ModList.get().getModContainerById("translationmod").get()).getModInfo().getDisplayName();
        title = modName + " - Settings";
    }
}

