/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.ConfigGui;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class EngineGui
extends CommonGui {
    private static final int guiWidth = 300;
    private static final int guiHeight = 150;
    private static final String title;
    private static final List<ITextComponent> googleTooltip;
    private static final List<ITextComponent> baiduTooltip;
    private String engine;
    private TextFieldWidget googleKeyBox;
    private TextFieldWidget baiduKeyBox;
    private TextFieldWidget baiduAppIdBox;

    EngineGui() {
        super(title, 150, 300);
        this.engine = (String)ConfigManager.config.translationEngine.get();
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int x, int y, float tick) {
        super.func_230430_a_(stack, x, y, tick);
        this.drawStringLine(stack, title, new String[]{"Please choose your translation engine", "The mod can only use either of them"}, 5);
        switch (this.engine) {
            case "google": {
                this.field_230712_o_.func_238421_b_(stack, "Cloud platform API key", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 75), 0x555555);
                this.googleKeyBox.func_230430_a_(stack, x, y, tick);
                this.field_230712_o_.func_238421_b_(stack, "Delete/Leave empty to use the free API", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 110), 0x555555);
                break;
            }
            case "baidu": {
                this.field_230712_o_.func_238421_b_(stack, "Baidu developer App ID", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 65), 0x555555);
                this.baiduAppIdBox.func_230430_a_(stack, x, y, tick);
                this.field_230712_o_.func_238421_b_(stack, "Baidu API key", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 95), 0x555555);
                this.baiduKeyBox.func_230430_a_(stack, x, y, tick);
            }
        }
        if (((Widget)this.field_230710_m_.get(0)).func_230449_g_()) {
            this.func_243308_b(stack, googleTooltip, x, y);
        }
        if (((Widget)this.field_230710_m_.get(1)).func_230449_g_()) {
            this.func_243308_b(stack, baiduTooltip, x, y);
        }
    }

    public void func_231160_c_() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        this.googleKeyBox = new TextFieldWidget(this.field_230712_o_, this.getLeftMargin(), this.getYOrigin() + 90, 290, 15, null);
        this.googleKeyBox.func_146205_d(true);
        this.googleKeyBox.func_146203_f(84);
        this.googleKeyBox.func_146185_a(true);
        this.googleKeyBox.func_146180_a((String)ConfigManager.config.googleKey.get());
        this.field_230705_e_.add(this.googleKeyBox);
        this.baiduAppIdBox = new TextFieldWidget(this.field_230712_o_, this.getLeftMargin(), this.getYOrigin() + 75, 290, 15, null){

            public void func_230982_a_(double mouseX, double mouseY) {
                EngineGui.this.baiduKeyBox.func_146195_b(false);
                super.func_230982_a_(mouseX, mouseY);
            }
        };
        this.baiduAppIdBox.func_146205_d(true);
        this.baiduAppIdBox.func_146203_f(20);
        this.baiduAppIdBox.func_146185_a(true);
        this.baiduAppIdBox.func_146180_a((String)ConfigManager.config.baiduAppId.get());
        this.field_230705_e_.add(this.baiduAppIdBox);
        this.baiduKeyBox = new TextFieldWidget(this.field_230712_o_, this.getLeftMargin(), this.getYOrigin() + 105, 290, 15, null){

            public void func_230982_a_(double mouseX, double mouseY) {
                super.func_230982_a_(mouseX, mouseY);
                EngineGui.this.baiduAppIdBox.func_146195_b(false);
            }
        };
        this.baiduKeyBox.func_146205_d(true);
        this.baiduKeyBox.func_146185_a(true);
        this.baiduKeyBox.func_146203_f(24);
        this.baiduKeyBox.func_146180_a((String)ConfigManager.config.baiduKey.get());
        this.field_230705_e_.add(this.baiduKeyBox);
        this.func_230480_a_((Widget)new Button(this.getLeftMargin(), this.getYOrigin() + 40, 140, 20, (ITextComponent)new StringTextComponent("Google"), button -> {
            button.field_230693_o_ = false;
            ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = true;
            this.engine = "google";
        }));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(145), this.getYOrigin() + 40, 140, 20, (ITextComponent)new StringTextComponent("Baidu"), button -> {
            button.field_230693_o_ = false;
            ((Widget)this.field_230710_m_.get((int)0)).field_230693_o_ = true;
            this.engine = "baidu";
        }));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 150 - 20 - 5, 100, 20, (ITextComponent)new StringTextComponent("Apply and close"), button -> this.applyKey()));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100) - 100 - 5, this.getYOrigin() + 150 - 20 - 5, 100, 20, (ITextComponent)new StringTextComponent("Back"), button -> this.configGui()));
        switch (this.engine) {
            case "google": {
                ((Widget)this.field_230710_m_.get((int)0)).field_230693_o_ = false;
                break;
            }
            case "baidu": {
                ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = false;
            }
        }
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 69 && !this.googleKeyBox.func_230999_j_()) {
            this.getMinecraft().field_195559_v.func_197967_a(false);
            this.getMinecraft().func_147108_a(null);
            return false;
        }
        return super.func_231046_a_(keyCode, scanCode, modifier);
    }

    private void configGui() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
        this.getMinecraft().func_147108_a((Screen)new ConfigGui());
    }

    private void applyKey() {
        this.getMinecraft().field_195559_v.func_197967_a(true);
        ConfigManager.config.googleKey.set((Object)this.googleKeyBox.func_146179_b());
        ConfigManager.config.baiduAppId.set((Object)this.baiduAppIdBox.func_146179_b());
        ConfigManager.config.baiduKey.set((Object)this.baiduKeyBox.func_146179_b());
        ConfigManager.config.translationEngine.set((Object)this.engine);
        ConfigManager.saveConfig();
        Log.logger.info("Saved engine options");
        ChatUtil.printChatMessage(true, "New translation engine options have been applied.", TextFormatting.WHITE);
        this.getMinecraft().func_147108_a(null);
    }

    static {
        googleTooltip = new ArrayList<ITextComponent>();
        baiduTooltip = new ArrayList<ITextComponent>();
        String modName = ((ModContainer)ModList.get().getModContainerById("translationmod").get()).getModInfo().getDisplayName();
        title = modName + " - Engine options";
        googleTooltip.add((ITextComponent)new StringTextComponent("By default, you are using the \"free\" version of Google translation"));
        googleTooltip.add((ITextComponent)new StringTextComponent("This is the same API the Google translate website is using"));
        googleTooltip.add((ITextComponent)new StringTextComponent("However, too many requests and Google will block you for a few minutes"));
        googleTooltip.add((ITextComponent)new StringTextComponent("Cloud translation API is the paid version of Google translate"));
        googleTooltip.add((ITextComponent)new StringTextComponent("Please check the mod page for details"));
        baiduTooltip.add((ITextComponent)new StringTextComponent("If you cannot use Google due to country restrictions,"));
        baiduTooltip.add((ITextComponent)new StringTextComponent("Baidu is your second option"));
        baiduTooltip.add((ITextComponent)new StringTextComponent("An account is needed to use this API (Phone verification required)"));
        baiduTooltip.add((ITextComponent)new StringTextComponent("Free tier only allows 1 request per second"));
        baiduTooltip.add((ITextComponent)new StringTextComponent("Paying allows for more requests per second"));
        baiduTooltip.add((ITextComponent)new StringTextComponent("Please check the mod page for details"));
    }
}

