/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.ConfigGui;
import com.ringosham.translationmod.gui.LangList;
import com.ringosham.translationmod.gui.RetranslateGui;
import com.ringosham.translationmod.translate.Retranslate;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class LanguageSelectGui
extends CommonGui {
    private static final int guiWidth = 400;
    private static final int guiHeight = 200;
    private static final String title;
    private final ConfigGui config;
    private final int langSelect;
    private final String sender;
    private final String message;
    private LangList langList;

    LanguageSelectGui(ConfigGui config, int langSelect) {
        super(title, 200, 400);
        this.config = config;
        this.langSelect = langSelect;
        this.message = null;
        this.sender = null;
    }

    LanguageSelectGui(String sender, String message) {
        super(title, 200, 400);
        this.message = message;
        this.sender = sender;
        this.config = null;
        this.langSelect = -1;
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int x, int y, float tick) {
        super.func_230430_a_(stack, x, y, tick);
        this.field_230712_o_.func_238421_b_(stack, title, (float)this.getLeftMargin(), (float)this.getTopMargin(), 0x555555);
        this.langList.func_230430_a_(stack, x, y, tick);
    }

    public void func_231160_c_() {
        this.langList = new LangList(this.getMinecraft(), this.field_230712_o_, 382, 152, this.getYOrigin() + 15, this.getYOrigin() + 200 - 10 - 20, 18);
        this.langList.func_230959_g_(this.getLeftMargin());
        this.field_230705_e_.add(this.langList);
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 200 - 20 - 5, 100, 20, (ITextComponent)new StringTextComponent("Select language"), button -> {
            if (this.langList.func_230958_g_() != null) {
                if (this.config != null) {
                    this.selectLanguage(((LangList.LangEntry)this.langList.func_230958_g_()).getLang());
                } else {
                    this.retranslate(((LangList.LangEntry)this.langList.func_230958_g_()).getLang());
                }
            }
        }));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin(), this.getYOrigin() + 200 - 20 - 5, 100, 20, (ITextComponent)new StringTextComponent("Back"), button -> {
            if (this.config != null) {
                this.selectLanguage(null);
            } else {
                this.getMinecraft().func_147108_a((Screen)new RetranslateGui());
            }
        }));
    }

    private void selectLanguage(Language lang) {
        this.getMinecraft().func_147108_a((Screen)new ConfigGui(this.config, this.langSelect, lang));
    }

    private void retranslate(Language source) {
        Retranslate retranslate = new Retranslate(this.sender, this.message, source, LangManager.getInstance().findLanguageFromName((String)ConfigManager.config.targetLanguage.get()));
        retranslate.start();
        this.getMinecraft().func_147108_a(null);
    }

    static {
        String modName = ((ModContainer)ModList.get().getModContainerById("translationmod").get()).getModInfo().getDisplayName();
        title = modName + " - Language select";
    }
}

