/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.google.common.primitives.Ints;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.TextButton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.lwjgl.opengl.GL11;

public class RegexGui
extends CommonGui {
    private static final String testMessage = "Notch --> English: Hello!";
    private static final int guiWidth = 400;
    private static final int guiHeight = 230;
    private static final List<ITextComponent> cheatsheet;
    private static final List<List<ITextComponent>> cheatsheetDesc;
    private static final String regexTest = "https://regexr.com";
    private static final String title;
    private int index;
    private final LinkedList<String> regexes = new LinkedList();
    private final LinkedList<Integer> groups = new LinkedList();
    private TextFieldWidget regexTextBox;
    private TextFieldWidget groupTextBox;

    RegexGui() {
        super(title, 230, 400);
        this.regexes.addAll((Collection)ConfigManager.config.regexList.get());
        this.groups.addAll((Collection)ConfigManager.config.groupList.get());
        this.index = this.regexes.size() - 1;
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int x, int y, float tick) {
        int group;
        super.func_230430_a_(stack, x, y, tick);
        this.drawStringLine(stack, title, new String[]{"Regex(Regular expression) are search patterns used to detect messages.", "You can use this website to test your regex.", "Cheatsheet: (Hover your mouse to see explanation)"}, 0);
        this.field_230712_o_.func_238421_b_(stack, "TIP: Combine classes and quantifiers together to match several characters", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 40), 0x555555);
        this.field_230712_o_.func_238421_b_(stack, this.index + 1 + " of " + Math.max(this.index + 1, this.regexes.size()), (float)(this.getLeftMargin() + 15 + 40), (float)(this.getYOrigin() + 230 - 20), 0x555555);
        String regex = this.regexTextBox.func_146179_b();
        int n = group = this.groupTextBox.func_146179_b().isEmpty() ? -1 : Integer.parseInt(this.groupTextBox.func_146179_b());
        if (this.validateRegex(regex)) {
            if (!this.isRegexConflict(regex)) {
                int groupCount = this.countGroups(regex);
                if (groupCount == 0) {
                    this.field_230712_o_.func_238421_b_(stack, TextFormatting.YELLOW + "Regex valid, but it needs at least 1 group to detect player names", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 120), 0x555555);
                } else {
                    this.field_230712_o_.func_238421_b_(stack, TextFormatting.GREEN + "Regex valid! The regex should stop at before the message content", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 120), 0x555555);
                }
                this.field_230712_o_.func_238421_b_(stack, "Possible match: " + this.findMatch(this.getChatLog(), regex), (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 110), 0x555555);
                if (groupCount > 0) {
                    this.field_230712_o_.func_238421_b_(stack, "Group number: (1 - " + groupCount + ")", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 80), 0x555555);
                } else {
                    this.field_230712_o_.func_238421_b_(stack, "Group number: (?)", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 80), 0x555555);
                }
                this.field_230712_o_.func_238421_b_(stack, "Matching username: " + this.matchUsername(this.findMatch(this.getChatLog(), regex), regex, group), (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 70), 0x555555);
            } else {
                this.field_230712_o_.func_238421_b_(stack, TextFormatting.RED + "Regex conflict with the mod messages! Please be more specific", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 120), 0x555555);
                this.field_230712_o_.func_238421_b_(stack, "Possible match: ---", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 110), 0x555555);
                this.field_230712_o_.func_238421_b_(stack, "Matching username: ---", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 70), 0x555555);
                this.field_230712_o_.func_238421_b_(stack, "Group number: (?)", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 80), 0x555555);
            }
        } else {
            this.field_230712_o_.func_238421_b_(stack, TextFormatting.RED + "Regex invalid! Please check your syntax", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 120), 0x555555);
            this.field_230712_o_.func_238421_b_(stack, "Possible match: ---", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 110), 0x555555);
            this.field_230712_o_.func_238421_b_(stack, "Matching username: ---", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 70), 0x555555);
            this.field_230712_o_.func_238421_b_(stack, "Group number: (?)", (float)this.getLeftMargin(), (float)(this.getYOrigin() + 230 - 80), 0x555555);
        }
        this.regexTextBox.func_230430_a_(stack, x, y, tick);
        this.groupTextBox.func_230430_a_(stack, x, y, tick);
        for (int i = 5; i < this.field_230710_m_.size(); ++i) {
            HoveringText button = (HoveringText)((Object)this.field_230710_m_.get(i));
            if (!button.func_230449_g_()) continue;
            this.func_243308_b(stack, button.getHoverText(), x, y);
        }
    }

    public void func_231160_c_() {
        this.regexTextBox = new TextFieldWidget(this.field_230712_o_, this.getLeftMargin(), this.getYOrigin() + 230 - 100, 390, 15, (ITextComponent)new StringTextComponent(""));
        this.regexTextBox.func_146205_d(true);
        this.regexTextBox.func_146203_f(200);
        this.regexTextBox.func_146185_a(true);
        this.regexTextBox.func_146180_a(this.regexes.get(this.index));
        this.groupTextBox = new TextFieldWidget(this.field_230712_o_, this.getLeftMargin(), this.getYOrigin() + 230 - 60, 390, 15, (ITextComponent)new StringTextComponent(""));
        this.groupTextBox.func_146205_d(true);
        this.groupTextBox.func_146203_f(10);
        this.groupTextBox.func_146185_a(true);
        this.groupTextBox.func_146180_a(Integer.toString(this.groups.get(this.index)));
        this.field_230705_e_.add(this.groupTextBox);
        this.field_230705_e_.add(this.regexTextBox);
        this.getMinecraft().field_195559_v.func_197967_a(false);
        this.func_230480_a_((Widget)new TextButton(this.getRightMargin(150), this.getYOrigin() + 25, this.getTextWidth(regexTest), (ITextComponent)new StringTextComponent(regexTest), button -> this.openLink(), 170));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin() + 5 + 20, this.getYOrigin() + 230 - 5 - 20, 20, 20, (ITextComponent)new StringTextComponent("+"), this::nextPage));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100), this.getYOrigin() + 230 - 5 - 20, 100, 20, (ITextComponent)new StringTextComponent("Save and close"), button -> this.applySettings()));
        this.func_230480_a_((Widget)new Button(this.getLeftMargin(), this.getYOrigin() + 230 - 5 - 20, 20, 20, (ITextComponent)new StringTextComponent("<"), this::previousPage));
        this.func_230480_a_((Widget)new Button(this.getRightMargin(100) - 5 - 100, this.getYOrigin() + 230 - 5 - 20, 100, 20, (ITextComponent)new StringTextComponent("Reset to default"), button -> this.resetDefault()));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin(), this.getYOrigin() + 45, cheatsheet.get(0), cheatsheetDesc.get(0)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin(), this.getYOrigin() + 55, cheatsheet.get(1), cheatsheetDesc.get(1)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin(), this.getYOrigin() + 65, cheatsheet.get(2), cheatsheetDesc.get(2)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin(), this.getYOrigin() + 75, cheatsheet.get(3), cheatsheetDesc.get(3)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin(), this.getYOrigin() + 85, cheatsheet.get(4), cheatsheetDesc.get(4)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin(), this.getYOrigin() + 95, cheatsheet.get(5), cheatsheetDesc.get(5)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin() + 210, this.getYOrigin() + 45, cheatsheet.get(6), cheatsheetDesc.get(6)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin() + 210, this.getYOrigin() + 55, cheatsheet.get(7), cheatsheetDesc.get(7)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin() + 210, this.getYOrigin() + 65, cheatsheet.get(8), cheatsheetDesc.get(8)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin() + 210, this.getYOrigin() + 75, cheatsheet.get(9), cheatsheetDesc.get(9)));
        this.func_230480_a_((Widget)new HoveringText(this.getLeftMargin() + 210, this.getYOrigin() + 85, cheatsheet.get(10), cheatsheetDesc.get(10)));
    }

    private void openLink() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
        this.getMinecraft().func_147108_a((Screen)new ConfirmOpenLinkScreen(ConfirmOpen -> {
            if (ConfirmOpen) {
                Util.func_110647_a().func_195640_a(regexTest);
            }
            this.getMinecraft().func_147108_a((Screen)this);
        }, regexTest, false));
        this.getMinecraft().field_195559_v.func_197967_a(true);
    }

    private void nextPage(Button button) {
        this.regexes.set(this.index, this.regexTextBox.func_146179_b());
        if (this.groupTextBox.func_146179_b().trim().isEmpty()) {
            this.groups.set(this.index, 0);
        } else {
            this.groups.set(this.index, Integer.parseInt(this.groupTextBox.func_146179_b()));
        }
        ++this.index;
        if (this.index == this.regexes.size()) {
            button.field_230693_o_ = false;
            this.regexes.add("");
            this.groups.add(1);
            this.regexTextBox.func_146180_a("");
            this.groupTextBox.func_146180_a("1");
        } else {
            this.regexTextBox.func_146180_a(this.regexes.get(this.index));
            this.groupTextBox.func_146180_a(this.groups.get(this.index).toString());
            button.func_238482_a_((ITextComponent)new StringTextComponent(">"));
            button.field_230693_o_ = true;
        }
        if (this.index >= this.regexes.size() - 1) {
            button.func_238482_a_((ITextComponent)new StringTextComponent("+"));
        }
        ((Widget)this.field_230710_m_.get((int)3)).field_230693_o_ = true;
        this.regexTextBox.func_146202_e();
        this.getMinecraft().field_195559_v.func_197967_a(true);
    }

    private void previousPage(Button button) {
        if (this.regexTextBox.func_146179_b().trim().isEmpty() || this.groupTextBox.func_146179_b().isEmpty()) {
            this.regexes.remove(this.index);
            this.groups.remove(this.index);
        } else {
            this.regexes.set(this.index, this.regexTextBox.func_146179_b());
            this.groups.set(this.index, Integer.parseInt(this.groupTextBox.func_146179_b()));
        }
        --this.index;
        if (this.index == 0) {
            button.field_230693_o_ = false;
        }
        if (this.regexes.size() - 1 == this.index) {
            ((Widget)this.field_230710_m_.get(1)).func_238482_a_((ITextComponent)new StringTextComponent("+"));
        } else {
            ((Widget)this.field_230710_m_.get(1)).func_238482_a_((ITextComponent)new StringTextComponent(">"));
        }
        ((Widget)this.field_230710_m_.get((int)1)).field_230693_o_ = true;
        this.regexTextBox.func_146180_a(this.regexes.get(this.index));
        this.groupTextBox.func_146180_a(this.groups.get(this.index).toString());
        this.regexTextBox.func_146202_e();
        this.getMinecraft().field_195559_v.func_197967_a(true);
    }

    private void resetDefault() {
        ((Widget)this.field_230710_m_.get((int)3)).field_230693_o_ = true;
        ((Widget)this.field_230710_m_.get(1)).func_238482_a_((ITextComponent)new StringTextComponent("+"));
        this.regexes.clear();
        this.regexes.addAll(Arrays.asList(ConfigManager.defaultRegex));
        this.groups.clear();
        this.groups.addAll(Ints.asList((int[])ConfigManager.defaultGroups));
        this.index = this.regexes.size() - 1;
        this.regexTextBox.func_146180_a(this.regexes.get(this.index));
        this.groupTextBox.func_146180_a(this.groups.get(this.index).toString());
        this.regexTextBox.func_146202_e();
        this.getMinecraft().field_195559_v.func_197967_a(true);
    }

    private void exitGui() {
        this.getMinecraft().field_195559_v.func_197967_a(false);
        this.getMinecraft().func_147108_a(null);
    }

    public boolean func_231042_a_(char typedchar, int keyCode) {
        if (this.groupTextBox.func_230999_j_()) {
            if (typedchar >= '0' && typedchar <= '9') {
                if (this.groupTextBox.func_146179_b().isEmpty() && typedchar != '0') {
                    return super.func_231042_a_(typedchar, keyCode);
                }
                if (!this.groupTextBox.func_146179_b().isEmpty()) {
                    return super.func_231042_a_(typedchar, keyCode);
                }
            }
            return false;
        }
        return super.func_231042_a_(typedchar, keyCode);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 69 && !this.regexTextBox.func_230999_j_()) {
            this.getMinecraft().func_147108_a(null);
            return false;
        }
        return super.func_231046_a_(keyCode, scanCode, modifier);
    }

    private boolean validateRegex(String regex) {
        if (regex == null) {
            return false;
        }
        if (regex.trim().isEmpty()) {
            return false;
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private int countGroups(String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher("Reality is a shitty game! -Katsuragi Keima");
        return matcher.groupCount();
    }

    private boolean isRegexConflict(String regex) {
        if (!regex.contains("^")) {
            regex = "^" + regex;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(testMessage);
        return matcher.find();
    }

    private List<String> getChatLog() {
        List fullChatLog = (List)ObfuscationReflectionHelper.getPrivateValue(NewChatGui.class, (Object)Minecraft.func_71410_x().field_71456_v.func_146158_b(), (String)"field_146252_h");
        ArrayList<String> chatLog = new ArrayList<String>();
        for (int i = 0; i < Math.min(fullChatLog.size(), 20); ++i) {
            ITextComponent chatLine = (ITextComponent)((ChatLine)fullChatLog.get(i)).func_238169_a_();
            if (chatLine instanceof TranslationTextComponent) {
                TranslationTextComponent ttc = (TranslationTextComponent)chatLine;
                chatLog.add(ttc.getString().replaceAll("\u00c2\u00a7(.)", ""));
                continue;
            }
            chatLog.add(((ITextComponent)((ChatLine)fullChatLog.get(i)).func_238169_a_()).func_150261_e().replaceAll("\u00c2\u00a7(.)", ""));
        }
        return chatLog;
    }

    private String findMatch(List<String> chatLog, String regex) {
        if (!regex.contains("^")) {
            regex = "^" + regex;
        }
        Pattern pattern = Pattern.compile(regex);
        for (String message : chatLog) {
            String matchMessage;
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) continue;
            String shorten = matchMessage = TextFormatting.GREEN + matcher.group(0) + TextFormatting.DARK_GRAY + message.replace(matcher.group(0), "");
            for (int i = this.getTextWidth(matchMessage); i > 120; --i) {
                shorten = shorten.substring(0, matchMessage.length() - 1);
            }
            shorten = shorten + "...";
            return matchMessage.length() < shorten.length() ? matchMessage : shorten;
        }
        return TextFormatting.RED + "No match from chat log :(";
    }

    private String matchUsername(String message, String regex, int group) {
        if (group == -1 || group > this.countGroups(regex) || message.equals(TextFormatting.RED + "No match from chat log :(")) {
            return "---";
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(message);
        if (!matcher.find()) {
            return TextFormatting.RED + "Can't find player username :(";
        }
        return matcher.group(group);
    }

    private void applySettings() {
        this.regexes.set(this.index, this.regexTextBox.func_146179_b());
        if (this.groupTextBox.func_146179_b().trim().isEmpty()) {
            this.groups.set(this.index, 0);
        } else {
            this.groups.set(this.index, Integer.parseInt(this.groupTextBox.func_146179_b()));
        }
        for (int i = 0; i < this.regexes.size(); ++i) {
            if (!this.validateRegex(this.regexes.get(i)) || this.isRegexConflict(this.regexes.get(i))) {
                this.regexes.remove(i);
                this.groups.remove(i);
                --i;
                continue;
            }
            int groupCount = this.countGroups(this.regexes.get(i));
            if (groupCount >= this.groups.get(i)) continue;
            this.regexes.remove(i);
            this.groups.remove(i);
            --i;
        }
        ConfigManager.config.regexList.set(this.regexes);
        ConfigManager.config.groupList.set(this.groups);
        ConfigManager.validateConfig();
        ChatUtil.printChatMessage(true, "Regex list applied", TextFormatting.WHITE);
        this.exitGui();
    }

    static {
        String modName = ((ModContainer)ModList.get().getModContainerById("translationmod").get()).getModInfo().getDisplayName();
        title = modName + " - Regex list";
        cheatsheet = new ArrayList<ITextComponent>();
        cheatsheetDesc = new ArrayList<List<ITextComponent>>();
        for (int i = 0; i < 12; ++i) {
            cheatsheetDesc.add(new ArrayList());
        }
        cheatsheet.add((ITextComponent)new StringTextComponent(". - Matches any character"));
        cheatsheetDesc.get(0).add((ITextComponent)new StringTextComponent("Matches any character"));
        cheatsheetDesc.get(0).add((ITextComponent)new StringTextComponent("The only exception is the newline character (\\n)"));
        cheatsheetDesc.get(0).add((ITextComponent)new StringTextComponent("Newlines are not used in chat so it doesn't matter"));
        cheatsheet.add((ITextComponent)new StringTextComponent("\\w - Matches word"));
        cheatsheetDesc.get(1).add((ITextComponent)new StringTextComponent("Matches all alphabets (Both capital and small), numbers and underscore"));
        cheatsheetDesc.get(1).add((ITextComponent)new StringTextComponent("Minecraft usernames are based on words. They are perfect to detect player names"));
        cheatsheet.add((ITextComponent)new StringTextComponent("\\d - Digit"));
        cheatsheetDesc.get(2).add((ITextComponent)new StringTextComponent("Matches all numbers"));
        cheatsheet.add((ITextComponent)new StringTextComponent("[a-g] - Match character in range"));
        cheatsheetDesc.get(3).add((ITextComponent)new StringTextComponent("Matches any characters in tis specific range"));
        cheatsheetDesc.get(3).add((ITextComponent)new StringTextComponent("Example: [a-g]"));
        cheatsheetDesc.get(3).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "a"));
        cheatsheetDesc.get(3).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "b"));
        cheatsheetDesc.get(3).add((ITextComponent)new StringTextComponent("\u2717 " + TextFormatting.RED + "z"));
        cheatsheet.add((ITextComponent)new StringTextComponent("* - Matches 0 or more"));
        cheatsheetDesc.get(4).add((ITextComponent)new StringTextComponent("Matches 0 or more of its character class"));
        cheatsheetDesc.get(4).add((ITextComponent)new StringTextComponent("Example: N\\w*"));
        cheatsheetDesc.get(4).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "N"));
        cheatsheetDesc.get(4).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "No"));
        cheatsheetDesc.get(4).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "Notch"));
        cheatsheet.add((ITextComponent)new StringTextComponent("+ - Matches 1 or more"));
        cheatsheetDesc.get(5).add((ITextComponent)new StringTextComponent("Matches 1 or more of a character/group"));
        cheatsheetDesc.get(5).add((ITextComponent)new StringTextComponent("Example: N\\w+"));
        cheatsheetDesc.get(5).add((ITextComponent)new StringTextComponent("\u2717 " + TextFormatting.RED + "N"));
        cheatsheetDesc.get(5).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "No"));
        cheatsheetDesc.get(5).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "Notch"));
        cheatsheet.add((ITextComponent)new StringTextComponent("? - Optional"));
        cheatsheetDesc.get(6).add((ITextComponent)new StringTextComponent("Exactly as the name suggests"));
        cheatsheetDesc.get(6).add((ITextComponent)new StringTextComponent("Example: (VIP )?\\w+"));
        cheatsheetDesc.get(6).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "VIP PlayerName"));
        cheatsheetDesc.get(6).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "PlayerName"));
        cheatsheet.add((ITextComponent)new StringTextComponent("{2,} - Matches n or more"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("Matches a group/character n times or more"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("Add a number after the comma if you want the it match x to y times"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("Or omit the comma if you want the it match exactly n times"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("Example: Level \\d{1,3}"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "Level 1"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "Level 420"));
        cheatsheetDesc.get(7).add((ITextComponent)new StringTextComponent("\u2717 " + TextFormatting.RED + "Level 42069"));
        cheatsheet.add((ITextComponent)new StringTextComponent("| - Either"));
        cheatsheetDesc.get(8).add((ITextComponent)new StringTextComponent("Must match either of them, but not both."));
        cheatsheetDesc.get(8).add((ITextComponent)new StringTextComponent("Example: (Dead)|(Alive) (\\w+)"));
        cheatsheetDesc.get(8).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "Dead PlayerName"));
        cheatsheetDesc.get(8).add((ITextComponent)new StringTextComponent("\u2713 " + TextFormatting.GREEN + "Alive PlayerName"));
        cheatsheetDesc.get(8).add((ITextComponent)new StringTextComponent("\u2717 " + TextFormatting.RED + "DeadAlive PlayerName"));
        cheatsheet.add((ITextComponent)new StringTextComponent("() - Group"));
        cheatsheetDesc.get(9).add((ITextComponent)new StringTextComponent("Think of groups as parentheses like in mathematics"));
        cheatsheetDesc.get(9).add((ITextComponent)new StringTextComponent("They also have a second function. Capture groups."));
        cheatsheetDesc.get(9).add((ITextComponent)new StringTextComponent("By specifying the group number below, the mod can know which group"));
        cheatsheetDesc.get(9).add((ITextComponent)new StringTextComponent(" contains the player's username"));
        cheatsheet.add((ITextComponent)new StringTextComponent("\\ - Escape character"));
        cheatsheetDesc.get(10).add((ITextComponent)new StringTextComponent("If you need to capture special characters mentioned in this list,"));
        cheatsheetDesc.get(10).add((ITextComponent)new StringTextComponent(" you will need to add an extra backslash to escape them."));
        cheatsheetDesc.get(10).add((ITextComponent)new StringTextComponent("Correct:" + TextFormatting.GREEN + " \\(VIP\\) \\w+"));
        cheatsheetDesc.get(10).add((ITextComponent)new StringTextComponent("Wrong:" + TextFormatting.RED + " (VIP) \\w+"));
    }

    public class HoveringText
    extends Button {
        private final List<ITextComponent> hoverText;

        HoveringText(int x, int y, ITextComponent text, List<ITextComponent> hoverText) {
            super(x, y, RegexGui.this.getTextWidth(text.func_150261_e()), 10, text, button -> {});
            this.hoverText = hoverText;
        }

        public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float tick) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RegexGui.this.field_230712_o_.func_238421_b_(stack, this.func_230458_i_().getString(), (float)this.field_230690_l_, (float)this.field_230691_m_, -11184811);
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
        }

        List<ITextComponent> getHoverText() {
            return this.hoverText;
        }
    }
}

