/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.TranslateResult;
import net.minecraft.util.text.TextFormatting;

public class Retranslate
extends Thread {
    private final String message;
    private final Language from;
    private final Language to;
    private final String sender;

    public Retranslate(String sender, String message, Language from, Language to) {
        this.sender = sender;
        this.message = message;
        this.from = from;
        this.to = to;
    }

    @Override
    public void run() {
        Translator translator = new Translator(this.message, this.from, this.to);
        if (this.from == this.to) {
            return;
        }
        TranslateResult translatedMessage = translator.translate(this.message.trim());
        if (translatedMessage == null) {
            ChatUtil.printChatMessage(true, "An error occurred during translation", TextFormatting.RED);
            return;
        }
        String fromStr = null;
        if (translatedMessage.getSourceLanguage() != null) {
            fromStr = translatedMessage.getSourceLanguage().getName();
        }
        String chatMessage = this.sender + " --> " + (fromStr == null ? "Unknown" : fromStr) + ": " + translatedMessage.getMessage();
        String hoverText = "Sender: " + this.sender + "\nTranslation: " + (fromStr == null ? "Unknown" : fromStr) + " -> " + this.to.getName();
        if (translatedMessage.getMessage().trim().equals(this.message.trim())) {
            ChatUtil.printChatMessage(true, "Translation failed. Try another language maybe?", TextFormatting.RED);
            return;
        }
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, (Boolean)ConfigManager.config.bold.get(), (Boolean)ConfigManager.config.italic.get(), (Boolean)ConfigManager.config.underline.get(), TextFormatting.func_96300_b((String)((String)ConfigManager.config.color.get())));
    }
}

