/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.client.BaiduClient;
import com.ringosham.translationmod.client.GoogleClient;
import com.ringosham.translationmod.client.GooglePaidClient;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.translate.types.TranslateResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;

public class Translator
extends Thread {
    private final String message;
    private final Language from;
    private final Language to;
    private static final LinkedList<TranslationLog> translationLog = new LinkedList();
    private static final int CACHE_SIZE = 100;
    private static boolean warnLimit = false;

    public Translator(String message, Language from, Language to) {
        this.message = message;
        this.from = from;
        this.to = to;
    }

    public static List<TranslationLog> getTranslationLog(int count) {
        int begin = translationLog.size() - count;
        if (begin < 0) {
            begin = 0;
        }
        return translationLog.subList(begin, translationLog.size());
    }

    public TranslateResult translate(String rawMessage) {
        if (this.from == this.to) {
            return null;
        }
        if ((rawMessage = rawMessage.trim()).length() == 0) {
            return null;
        }
        for (TranslationLog log : translationLog) {
            if (!rawMessage.equals(log.message) || this.to != log.result.getSourceLanguage()) continue;
            return new TranslateResult(log.result.getMessage(), log.result.getSourceLanguage());
        }
        switch ((String)ConfigManager.config.translationEngine.get()) {
            case "google": {
                if (!((String)ConfigManager.config.googleKey.get()).equals("") && !GooglePaidClient.getDisable()) {
                    GooglePaidClient google = new GooglePaidClient();
                    RequestResult transRequest = this.from == null ? google.translateAuto(rawMessage, this.to) : google.translate(rawMessage, this.from, this.to);
                    if (transRequest.getCode() != 200) {
                        this.logException(transRequest);
                        return null;
                    }
                    return new TranslateResult(transRequest.getMessage(), transRequest.getFrom());
                }
                if (!GoogleClient.isAccessDenied()) {
                    GoogleClient google = new GoogleClient();
                    RequestResult transRequest = this.from == null ? google.translateAuto(rawMessage, this.to) : google.translate(rawMessage, this.from, this.to);
                    if (transRequest.getCode() != 200) {
                        this.logException(transRequest);
                        return null;
                    }
                    return new TranslateResult(transRequest.getMessage(), transRequest.getFrom());
                }
                return null;
            }
            case "baidu": {
                BaiduClient baidu = new BaiduClient();
                RequestResult transRequest = this.from == null ? baidu.translateAuto(rawMessage, this.to) : baidu.translate(rawMessage, this.from, this.to);
                if (transRequest.getCode() != 200) {
                    this.logException(transRequest);
                    return null;
                }
                return new TranslateResult(transRequest.getMessage(), transRequest.getFrom());
            }
        }
        return null;
    }

    private String findPlayerName(String message, int regexIndex) {
        Pattern pattern = Pattern.compile((String)((List)ConfigManager.config.regexList.get()).get(regexIndex));
        Matcher matcher = pattern.matcher(message);
        matcher.find();
        return matcher.group((Integer)((List)ConfigManager.config.groupList.get()).get(regexIndex));
    }

    private void logException(RequestResult transRequest) {
        switch (transRequest.getCode()) {
            case 1: {
                Log.logger.error("Cannot connect to translation server. Is player offline?");
                break;
            }
            case 2: {
                Log.logger.error(transRequest.getMessage());
                break;
            }
            case 411: {
                Log.logger.error("Google API >> API call error");
                ChatUtil.printChatMessage(true, "API call error. Please report this error as it shouldn't happen", TextFormatting.RED);
                break;
            }
            case 429: {
                Log.logger.warn("Google denied access to translation API. Pausing translation for 5 minutes");
                ChatUtil.printChatMessage(true, "Google translate has stopped responding. Pausing translations", TextFormatting.YELLOW);
                break;
            }
            case 403: {
                Log.logger.error("Google API >> Exceeded API quota / User rate limit reached");
                ChatUtil.printChatMessage(true, "You have exceeded your quota / rate limit. Please check your quota settings", TextFormatting.RED);
                ChatUtil.printChatMessage(true, "Falling back to free version until you restart the game", TextFormatting.RED);
                GooglePaidClient.setDisable();
                break;
            }
            case 400: {
                Log.logger.error("Google API >> API key invalid");
                ChatUtil.printChatMessage(true, "API key invalid. If you do not wish to use a key, please remove it from the settings", TextFormatting.RED);
                break;
            }
            case 500: {
                Log.logger.error("Google API >> Failed to determine source language: " + transRequest.getMessage());
                ChatUtil.printChatMessage(true, "Server side failure. Cannot translate", TextFormatting.RED);
                break;
            }
            case 52001: {
                Log.logger.error("Baidu API >> Connection timeout");
                break;
            }
            case 52002: {
                Log.logger.error("Baidu API >> Server side failure");
                ChatUtil.printChatMessage(true, "Server side failure. Cannot translate", TextFormatting.RED);
                break;
            }
            case 52003: {
                Log.logger.error("Baidu API >> Unauthorized request");
                ChatUtil.printChatMessage(true, "Authentication failure. Please check your App ID and API key", TextFormatting.RED);
                break;
            }
            case 54003: {
                Log.logger.warn("Baidu API >> Restricted request per second limit");
                if (warnLimit) break;
                ChatUtil.printChatMessage(true, "Request restricted due to tier limits. Consider upgrading your plan", TextFormatting.YELLOW);
                warnLimit = true;
                break;
            }
            case 54004: {
                Log.logger.error("Baidu API >> Not enough balance");
                ChatUtil.printChatMessage(true, "Balance insufficient. Please go to Baidu's control panel to top up", TextFormatting.RED);
                break;
            }
            case 54005: {
                Log.logger.error("Baidu API >> Request too large");
                ChatUtil.printChatMessage(true, "Request denied due to size too large", TextFormatting.YELLOW);
                break;
            }
            case 58000: {
                Log.logger.error("Baidu API >> Client IP is not whitelisted");
                ChatUtil.printChatMessage(true, "Request denied due to client IP not whitelisted. Please add your IP or remove whitelisting in the Baidu control panel", TextFormatting.RED);
                break;
            }
            case 58001: {
                Log.logger.error("Baidu API >> Translation direction not supported");
                ChatUtil.printChatMessage(true, "Cannot translate from " + transRequest.getFrom().getName() + " to " + transRequest.getTo().getName(), TextFormatting.RED);
                break;
            }
            case 58002: {
                Log.logger.error("Baidu API >> Translation service is not enabled");
                ChatUtil.printChatMessage(true, "Translation service is not enabled. Please turn it on in Baidu's control panel", TextFormatting.RED);
                break;
            }
            case 90107: {
                Log.logger.error("Baidu API >> Verification failed");
                ChatUtil.printChatMessage(true, "Verification failed. Please check your verification status", TextFormatting.RED);
                break;
            }
            case 100000: {
                Log.logger.error("Baidu API >> Language not supported");
                ChatUtil.printChatMessage(true, "Selected language is not supported by your translation engine", TextFormatting.RED);
                break;
            }
            default: {
                Log.logger.error("Unknown error/Server side failure: " + transRequest.getMessage());
            }
        }
    }

    @Override
    public void run() {
        int regexIndex = 0;
        if (this.message.trim().isEmpty()) {
            return;
        }
        String messageTrim = this.message.replaceAll("\u00a7(.)", "");
        String headerMatch = null;
        Iterator iterator = ((List)ConfigManager.config.regexList.get()).iterator();
        while (iterator.hasNext()) {
            Pattern pattern;
            Matcher matcher;
            String regex;
            String regexFixed = regex = (String)iterator.next();
            if (!regex.contains("^")) {
                regexFixed = "^" + regex;
            }
            if (!(matcher = (pattern = Pattern.compile(regexFixed)).matcher(messageTrim)).find()) continue;
            if (headerMatch == null) {
                headerMatch = matcher.group(0);
                regexIndex = ((List)ConfigManager.config.regexList.get()).indexOf(regex);
                continue;
            }
            if (headerMatch.length() >= matcher.group(0).length()) continue;
            headerMatch = matcher.group(0);
            regexIndex = ((List)ConfigManager.config.regexList.get()).indexOf(regex);
        }
        if (headerMatch == null) {
            return;
        }
        String sender = this.findPlayerName(headerMatch, regexIndex);
        if (sender == null) {
            return;
        }
        Pattern pattern = Pattern.compile((String)((List)ConfigManager.config.regexList.get()).get(regexIndex));
        Matcher matcher = pattern.matcher(messageTrim);
        matcher.find();
        String rawMessage = messageTrim.replace(matcher.group(0), "");
        TranslateResult translatedMessage = this.translate(rawMessage);
        if (translatedMessage == null) {
            return;
        }
        this.addToLog(new TranslationLog(sender, rawMessage, translatedMessage));
        String fromStr = null;
        if (translatedMessage.getSourceLanguage() != null) {
            fromStr = translatedMessage.getSourceLanguage().getName();
        }
        String chatMessage = sender + " --> " + (fromStr == null ? "Unknown" : fromStr) + ": " + translatedMessage.getMessage();
        String hoverText = "Sender: " + sender + "\nTranslation: " + (fromStr == null ? "Unknown" : fromStr) + " -> " + this.to.getName();
        if (translatedMessage.getMessage().trim().equals(rawMessage.trim())) {
            return;
        }
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, (Boolean)ConfigManager.config.bold.get(), (Boolean)ConfigManager.config.italic.get(), (Boolean)ConfigManager.config.underline.get(), TextFormatting.func_96300_b((String)((String)ConfigManager.config.color.get())));
    }

    private void addToLog(TranslationLog log) {
        if (!translationLog.contains(log)) {
            translationLog.add(log);
        }
        if (translationLog.size() > 100) {
            translationLog.pollFirst();
        }
    }

    public static class TranslationLog {
        private final String sender;
        private final String message;
        private final TranslateResult result;

        public TranslationLog(String sender, String message, TranslateResult result) {
            this.sender = sender;
            this.message = message;
            this.result = result;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSender() {
            return this.sender;
        }

        public TranslateResult getResult() {
            return this.result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TranslationLog that = (TranslationLog)o;
            return Objects.equals(this.sender, that.sender) && Objects.equals(this.message, that.message) && Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            return Objects.hash(this.sender, this.message, this.result);
        }
    }
}

