/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wolfshotz.dml.DragonMountsLegacy;
import wolfshotz.dml.client.model.DragonModel;
import wolfshotz.dml.client.render.RenderTypes;
import wolfshotz.dml.entities.TameableDragonEntity;

public class DragonRenderer
extends MobRenderer<TameableDragonEntity, DragonModel> {
    public static final String TEX_PATH = "textures/entity/dragon/";
    public static final ResourceLocation DISSOLVE_TEXTURE = DragonRenderer.rl("dissolve.png");
    public ResourceLocation bodyTexture;
    public ResourceLocation saddleTexture;
    public ResourceLocation glowTexture;

    public DragonRenderer(EntityRendererManager renderManagerIn, EntityType<? extends TameableDragonEntity> type) {
        super(renderManagerIn, (EntityModel)new DragonModel(type), 2.0f);
        this.func_177094_a(new GlowLayer());
        this.func_177094_a(new SaddleLayer());
    }

    public void render(TameableDragonEntity dragon, float yaw, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        Entity entity;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)dragon, (LivingRenderer)this, partialTicks, ms, buffer, light))) {
            return;
        }
        ms.func_227860_a_();
        ((DragonModel)this.field_77045_g).field_217112_c = this.func_77040_d((LivingEntity)dragon, partialTicks);
        ((DragonModel)this.field_77045_g).field_217114_e = dragon.func_70631_g_();
        float terpYawOff = MathHelper.func_219805_h((float)partialTicks, (float)dragon.field_70760_ar, (float)dragon.field_70761_aq);
        float terpYaw = MathHelper.func_219805_h((float)partialTicks, (float)dragon.field_70758_at, (float)dragon.field_70759_as);
        float yawDiff = terpYaw - terpYawOff;
        float lerpPitch = MathHelper.func_219799_g((float)partialTicks, (float)dragon.field_70127_C, (float)dragon.field_70125_A);
        float rotation = this.func_77044_a((LivingEntity)dragon, partialTicks);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (dragon.func_70089_S()) {
            limbSwingAmount = Math.min(1.0f, MathHelper.func_219799_g((float)partialTicks, (float)dragon.field_184618_aE, (float)dragon.field_70721_aZ));
            limbSwing = dragon.field_184619_aG - dragon.field_70721_aZ * (1.0f - partialTicks);
            if (dragon.func_70631_g_()) {
                limbSwing *= 3.0f;
            }
        }
        this.applyRotations(dragon, ms, rotation, terpYawOff, partialTicks);
        ms.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.preRenderCallback(dragon, ms, partialTicks);
        ms.func_227861_a_(0.0, (double)-1.501f, 0.0);
        ((DragonModel)this.field_77045_g).setLivingAnimations(dragon, limbSwing, limbSwingAmount, partialTicks);
        ((DragonModel)this.field_77045_g).setRotationAngles(dragon, limbSwing, limbSwingAmount, rotation, yawDiff, lerpPitch);
        this.renderModel(dragon, ms, buffer, light, DragonRenderer.func_229117_c_((LivingEntity)dragon, (float)this.func_225625_b_((LivingEntity)dragon, partialTicks)), this.getRenderType(dragon, this.getEntityTexture(dragon)));
        if (!dragon.func_175149_v()) {
            for (LayerRenderer layer : this.field_177097_h) {
                layer.func_225628_a_(ms, buffer, light, (Entity)dragon, limbSwing, limbSwingAmount, partialTicks, rotation, yawDiff, lerpPitch);
            }
        }
        ms.func_227865_b_();
        if (this.func_177070_b((MobEntity)dragon)) {
            this.func_225629_a_((Entity)dragon, dragon.func_145748_c_(), ms, buffer, light);
        }
        if ((entity = dragon.func_110166_bE()) != null) {
            this.renderLeash(dragon, partialTicks, ms, buffer, entity);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)dragon, (LivingRenderer)this, partialTicks, ms, buffer, light));
    }

    public void renderModel(TameableDragonEntity dragon, MatrixStack ms, IRenderTypeBuffer buffer, int packedLight, int overlay, RenderType renderType) {
        float deathTime = (float)dragon.getDeathTime() / (float)dragon.getMaxDeathTime();
        if (deathTime > 0.0f) {
            IVertexBuilder dissolve = buffer.getBuffer(RenderType.func_239264_a_((ResourceLocation)DISSOLVE_TEXTURE, (float)deathTime));
            ((DragonModel)this.field_77045_g).func_225598_a_(ms, dissolve, packedLight, OverlayTexture.func_229200_a_((float)0.0f, (boolean)true), 1.0f, 1.0f, 1.0f, 1.0f);
            IVertexBuilder decal = buffer.getBuffer(RenderType.func_228648_g_((ResourceLocation)this.getEntityTexture(dragon)));
            ((DragonModel)this.field_77045_g).func_225598_a_(ms, decal, packedLight, OverlayTexture.func_229200_a_((float)0.0f, (boolean)true), 1.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        boolean visibleToPlayer = !this.func_225622_a_((LivingEntity)dragon) && !dragon.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        IVertexBuilder builder = buffer.getBuffer(renderType);
        ((DragonModel)this.field_77045_g).func_225598_a_(ms, builder, packedLight, overlay, 1.0f, 1.0f, 1.0f, visibleToPlayer ? 0.15f : 1.0f);
    }

    protected void preRenderCallback(TameableDragonEntity dragon, MatrixStack ms, float partialTickTime) {
        float scale = dragon.getScale();
        float matrixScale = scale * 0.8f;
        ms.func_227862_a_(matrixScale, matrixScale, matrixScale);
        this.field_76989_e = scale * 2.0f;
    }

    protected void applyRotations(TameableDragonEntity dragon, MatrixStack ms, float ageInTicks, float rotationYaw, float partialTicks) {
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - rotationYaw));
    }

    public ResourceLocation getEntityTexture(TameableDragonEntity entity) {
        if (this.bodyTexture == null) {
            this.bodyTexture = DragonRenderer.rl(entity.func_200600_R().getRegistryName().func_110623_a() + "/body.png");
        }
        return this.bodyTexture;
    }

    public ResourceLocation getSaddleTexture(TameableDragonEntity entity) {
        if (this.saddleTexture == null) {
            this.saddleTexture = DragonRenderer.rl(entity.func_200600_R().getRegistryName().func_110623_a() + "/saddle.png");
        }
        return this.saddleTexture;
    }

    public ResourceLocation getGlowTexture(TameableDragonEntity entity) {
        if (this.glowTexture == null) {
            this.glowTexture = DragonRenderer.rl(entity.func_200600_R().getRegistryName().func_110623_a() + "/glow.png");
        }
        return this.glowTexture;
    }

    public RenderType getRenderType(TameableDragonEntity dragon, ResourceLocation texture) {
        boolean isVisible = this.func_225622_a_((LivingEntity)dragon);
        if (!isVisible && dragon.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            return RenderType.func_239268_f_((ResourceLocation)texture);
        }
        if (isVisible) {
            return ((DragonModel)this.func_217764_d()).func_228282_a_(texture);
        }
        if (Minecraft.func_71410_x().func_238206_b_((Entity)dragon)) {
            return RenderType.func_228654_j_((ResourceLocation)texture);
        }
        return null;
    }

    private <E extends Entity> void renderLeash(TameableDragonEntity entity, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, E leashHolder) {
        matrixStackIn.func_227860_a_();
        Vector3d vector3d = leashHolder.func_241843_o(partialTicks);
        double d0 = (double)(MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70761_aq, (float)entity.field_70760_ar) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d1 = entity.func_241205_ce_();
        double d1 = Math.cos(d0) * vector3d1.field_72449_c + Math.sin(d0) * vector3d1.field_72450_a;
        double d2 = Math.sin(d0) * vector3d1.field_72449_c - Math.cos(d0) * vector3d1.field_72450_a;
        double d3 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70169_q, (double)entity.func_226277_ct_()) + d1;
        double d4 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70167_r, (double)entity.func_226278_cu_()) + vector3d1.field_72448_b;
        double d5 = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70166_s, (double)entity.func_226281_cx_()) + d2;
        matrixStackIn.func_227861_a_(d1, vector3d1.field_72448_b, d2);
        float f = (float)(vector3d.field_72450_a - d3);
        float f1 = (float)(vector3d.field_72448_b - d4);
        float f2 = (float)(vector3d.field_72449_c - d5);
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228649_h_());
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        float f4 = MathHelper.func_226165_i_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(entity.func_174824_e(partialTicks));
        BlockPos blockpos1 = new BlockPos(leashHolder.func_174824_e(partialTicks));
        int i = this.func_225624_a_((Entity)entity, blockpos);
        int j = leashHolder.func_70027_ad() ? 15 : leashHolder.field_70170_p.func_226658_a_(LightType.BLOCK, blockpos1);
        int k = entity.field_70170_p.func_226658_a_(LightType.SKY, blockpos);
        int l = entity.field_70170_p.func_226658_a_(LightType.SKY, blockpos1);
        DragonRenderer.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.025f, (float)f5, (float)f6);
        DragonRenderer.func_229119_a_((IVertexBuilder)ivertexbuilder, (Matrix4f)matrix4f, (float)f, (float)f1, (float)f2, (int)i, (int)j, (int)k, (int)l, (float)0.025f, (float)0.0f, (float)f5, (float)f6);
        matrixStackIn.func_227865_b_();
    }

    public static ResourceLocation rl(String path) {
        return DragonMountsLegacy.rl(TEX_PATH + path);
    }

    class GlowLayer
    extends LayerRenderer<TameableDragonEntity, DragonModel> {
        public GlowLayer() {
            super((IEntityRenderer)DragonRenderer.this);
        }

        public void render(MatrixStack ms, IRenderTypeBuffer bufferIn, int light, TameableDragonEntity dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            DragonRenderer.this.renderModel(dragon, ms, bufferIn, light, OverlayTexture.field_229196_a_, RenderTypes.getGlow(DragonRenderer.this.getGlowTexture(dragon)));
        }
    }

    class SaddleLayer
    extends LayerRenderer<TameableDragonEntity, DragonModel> {
        public SaddleLayer() {
            super((IEntityRenderer)DragonRenderer.this);
        }

        public void render(MatrixStack ms, IRenderTypeBuffer buffer, int packedLight, TameableDragonEntity dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (dragon.isSaddled()) {
                DragonRenderer.this.renderModel(dragon, ms, buffer, packedLight, LivingRenderer.func_229117_c_((LivingEntity)dragon, (float)0.0f), DragonRenderer.this.getRenderType(dragon, DragonRenderer.this.getSaddleTexture(dragon)));
            }
        }
    }
}

