/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.data;

import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.misc.LazySpawnEggItem;

class Models {
    Models() {
    }

    static class Blocks
    extends BlockStateProvider {
        public Blocks(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "dragonmounts", exFileHelper);
        }

        protected void registerStatesAndModels() {
            for (RegistryObject blockRegistryObject : DMLRegistry.BLOCKS.getEntries()) {
                Block block = (Block)blockRegistryObject.get();
                String path = block.getRegistryName().func_110623_a();
                BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent(path, "dragon_egg");
                if (block != DMLRegistry.ENDER_EGG_BLOCK.get()) {
                    ((BlockModelBuilder)builder.texture("all", "block/" + path)).texture("particle", "block/" + path);
                }
                this.simpleBlock(block, ConfiguredModel.builder().modelFile((ModelFile)builder).build());
            }
        }
    }

    static class Items
    extends ItemModelProvider {
        public Items(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "dragonmounts", existingFileHelper);
        }

        protected void registerModels() {
            DMLRegistry.ITEMS.getEntries().stream().map(RegistryObject::get).forEach(item -> {
                String path = item.getRegistryName().func_110623_a();
                String parent = item instanceof LazySpawnEggItem ? "item/template_spawn_egg" : "dragonmounts:block/" + path;
                ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation(parent)));
            });
        }

        public String func_200397_b() {
            return "Dragon Mounts Item Models";
        }
    }
}

