/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.entities.ai.goals;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import wolfshotz.dml.entities.TameableDragonEntity;

public class DragonFollowOwnerGoal
extends Goal {
    private final TameableDragonEntity dragon;
    private final float minDist;
    private final float maxDist;
    private final float tpDist;
    private LivingEntity owner;
    private int pathRetryTimer;

    public DragonFollowOwnerGoal(TameableDragonEntity dragon, float minDist, float maxDist, float tpDist) {
        this.dragon = dragon;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.tpDist = tpDist;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (this.dragon.func_233685_eM_()) {
            return false;
        }
        if (this.dragon.func_110167_bD()) {
            return false;
        }
        LivingEntity owner = this.dragon.func_70902_q();
        if (owner == null) {
            return false;
        }
        if (owner.func_175149_v()) {
            return false;
        }
        if (this.dragon.func_184215_y((Entity)owner)) {
            return false;
        }
        if (this.dragon.func_70068_e((Entity)owner) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean func_75253_b() {
        if (this.dragon.func_70661_as().func_75500_f()) {
            return false;
        }
        if (this.dragon.func_233685_eM_()) {
            return false;
        }
        return this.dragon.func_70068_e((Entity)this.owner) <= (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.pathRetryTimer = 0;
    }

    public void func_75246_d() {
        this.dragon.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.dragon.func_70646_bf());
        if (--this.pathRetryTimer > 0) {
            return;
        }
        this.pathRetryTimer = 10;
        if (this.dragon.func_70068_e((Entity)this.owner) > (double)this.tpDist) {
            this.tryTeleportToOwner();
            return;
        }
        this.dragon.func_70661_as().func_75497_a((Entity)this.owner, 1.0);
    }

    public void tryTeleportToOwner() {
        Random rng = this.dragon.func_70681_au();
        BlockPos.Mutable potentialPos = new BlockPos.Mutable();
        for (int i = 0; i < 10; ++i) {
            double x = MathHelper.func_76136_a((Random)rng, (int)-3, (int)3);
            double y = this.owner.func_233570_aj_() ? 0.0 : (double)MathHelper.func_76136_a((Random)rng, (int)-1, (int)1);
            double z = MathHelper.func_76136_a((Random)rng, (int)-3, (int)3);
            potentialPos.func_189532_c(this.owner.func_226277_ct_() + x, this.owner.func_226278_cu_() + y, this.owner.func_226281_cx_() + z);
            if (WalkNodeProcessor.func_237231_a_((IBlockReader)this.dragon.field_70170_p, (BlockPos.Mutable)this.dragon.func_233580_cy_().func_239590_i_()) != PathNodeType.WALKABLE || !this.dragon.field_70170_p.func_226665_a__((Entity)this.dragon, this.dragon.func_174813_aQ().func_186670_a(potentialPos.func_177973_b((Vector3i)this.dragon.func_233580_cy_())))) continue;
            this.dragon.func_70107_b(potentialPos.func_177958_n(), potentialPos.func_177956_o(), potentialPos.func_177952_p());
            this.dragon.func_70661_as().func_75499_g();
            return;
        }
    }
}

