/*
 * Decompiled with CFR 0.152.
 */
package wolfshotz.dml.misc;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.tuple.Pair;
import wolfshotz.dml.DMLRegistry;
import wolfshotz.dml.entities.DragonEggEntity;
import wolfshotz.dml.entities.TameableDragonEntity;

public class DragonEggBlock
extends net.minecraft.block.DragonEggBlock {
    private static ImmutableMap<EntityType<?>, Block> LOOK_UP;
    public final Supplier<EntityType<? extends TameableDragonEntity>> breed;
    private final ToIntFunction<DragonEggEntity> habitatFunc;
    private final int primColor;
    private final int secColor;

    public DragonEggBlock(Supplier<EntityType<? extends TameableDragonEntity>> breed, ToIntFunction<DragonEggEntity> habitatPoints, int primColor, int secColor) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150380_bt).func_200948_a(1.0f, 9.0f));
        this.habitatFunc = habitatPoints;
        this.breed = breed;
        this.primColor = primColor;
        this.secColor = secColor;
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        if (this.breed.get() == DMLRegistry.ENDER_DRAGON_ENTITY.get()) {
            super.func_196270_a(state, worldIn, pos, player);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        DragonEggBlock.startHatching((Block)this, worldIn, pos);
        return ActionResultType.SUCCESS;
    }

    public int getHabitatPoints(DragonEggEntity egg) {
        return this.habitatFunc.applyAsInt(egg);
    }

    public Pair<Integer, Integer> getColors() {
        return Pair.of((Object)this.primColor, (Object)this.secColor);
    }

    public float getColorR(boolean primary) {
        int color = primary ? this.primColor : this.secColor;
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public float getColorG(boolean primary) {
        int color = primary ? this.primColor : this.secColor;
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public float getColorB(boolean primary) {
        int color = primary ? this.primColor : this.secColor;
        return (float)(color & 0xFF) / 255.0f;
    }

    public static void startHatching(Block block, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            DragonEggEntity egg = (DragonEggEntity)((EntityType)DMLRegistry.EGG_ENTITY.get()).func_200721_a(world);
            egg.setEggType(block);
            egg.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
            world.func_217376_c((Entity)egg);
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public static void onVanillaEggActivate(PlayerInteractEvent.RightClickBlock evt) {
        World world = evt.getWorld();
        Block block = world.func_180495_p(evt.getPos()).func_177230_c();
        if (block == Blocks.field_150380_bt) {
            evt.setCanceled(true);
            evt.setUseBlock(Event.Result.DENY);
            DragonEggBlock.startHatching((Block)DMLRegistry.ENDER_EGG_BLOCK.get(), world, evt.getPos());
        }
    }

    public static DragonEggBlock lookUp(EntityType<?> dragonType) {
        if (LOOK_UP == null) {
            LOOK_UP = ImmutableMap.builder().put((Object)DMLRegistry.AETHER_DRAGON_ENTITY.get(), (Object)DMLRegistry.AETHER_EGG_BLOCK.get()).put((Object)DMLRegistry.ENDER_DRAGON_ENTITY.get(), (Object)DMLRegistry.ENDER_EGG_BLOCK.get()).put((Object)DMLRegistry.FIRE_DRAGON_ENTITY.get(), (Object)DMLRegistry.FIRE_EGG_BLOCK.get()).put((Object)DMLRegistry.FOREST_DRAGON_ENTITY.get(), (Object)DMLRegistry.FOREST_EGG_BLOCK.get()).put((Object)DMLRegistry.GHOST_DRAGON_ENTITY.get(), (Object)DMLRegistry.GHOST_EGG_BLOCK.get()).put((Object)DMLRegistry.ICE_DRAGON_ENTITY.get(), (Object)DMLRegistry.ICE_EGG_BLOCK.get()).put((Object)DMLRegistry.NETHER_DRAGON_ENTITY.get(), (Object)DMLRegistry.NETHER_EGG_BLOCK.get()).put((Object)DMLRegistry.WATER_DRAGON_ENTITY.get(), (Object)DMLRegistry.WATER_EGG_BLOCK.get()).build();
        }
        return (DragonEggBlock)((Object)LOOK_UP.getOrDefault(dragonType, (Object)DMLRegistry.AETHER_EGG_BLOCK.get()));
    }
}

