/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class GuiScreenTooltip
extends Screen {
    protected List<GuiTextLabel> labelList = new ArrayList<GuiTextLabel>();

    protected GuiScreenTooltip(BaseComponent titleIn) {
        super((Component)titleIn);
    }

    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        for (GuiTextLabel label : this.labelList) {
            label.render(this, ms);
        }
        if (ModRPGHud.instance.settings.getBoolValue("enable_button_tooltip").booleanValue()) {
            this.drawTooltip(ms, mouseX, mouseY);
        }
    }

    private void drawTooltip(PoseStack ms, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font fontRenderer = mc.f_91062_;
        GuiScreenTooltip gui = null;
        if (!(mc.f_91080_ instanceof GuiScreenTooltip)) {
            return;
        }
        gui = (GuiScreenTooltip)mc.f_91080_;
        boolean shouldRenderTooltip = false;
        GuiButtonTooltip button = null;
        for (int x = 0; x < this.m_6702_().size(); ++x) {
            GuiEventListener b = (GuiEventListener)this.m_6702_().get(x);
            if (b instanceof GuiButtonTooltip) {
                button = (GuiButtonTooltip)b;
            }
            if (button == null || !button.m_5702_() && !button.m_93696_()) continue;
            shouldRenderTooltip = true;
            break;
        }
        if (shouldRenderTooltip) {
            int posX = mouseX + 5;
            int posY = mouseY + 5;
            int totalWidth = 0;
            boolean reverseY = false;
            String[] tooltip = button.getTooltip();
            if (tooltip != null) {
                int id;
                int counter = 0;
                for (id = 0; id < tooltip.length; ++id) {
                    int width = fontRenderer.m_92895_(tooltip[id]);
                    if (totalWidth < width) {
                        totalWidth = fontRenderer.m_92895_(tooltip[id]);
                    }
                    ++counter;
                }
                if ((posX -= totalWidth / 2) + totalWidth + 10 > gui.f_96543_) {
                    posX -= posX + totalWidth + 10 - gui.f_96543_;
                }
                if (posX < 0) {
                    posX = 0;
                }
                if (posY + 3 + tooltip.length * 12 + 2 > gui.f_96544_) {
                    reverseY = true;
                }
                if (reverseY) {
                    GuiScreenTooltip.m_93172_((PoseStack)ms, (int)posX, (int)(posY - 3 - tooltip.length * 12 - 2), (int)(posX + totalWidth + 10), (int)posY, (int)-1610612736);
                } else {
                    GuiScreenTooltip.m_93172_((PoseStack)ms, (int)posX, (int)posY, (int)(posX + totalWidth + 10), (int)(posY + 3 + tooltip.length * 12 + 2), (int)-1610612736);
                }
                for (id = 0; id < tooltip.length; ++id) {
                    if (tooltip[id].isEmpty()) continue;
                    if (reverseY) {
                        Gui.m_93236_((PoseStack)ms, (Font)fontRenderer, (String)tooltip[id], (int)(posX + 5), (int)(posY - 2 - 12 * (counter - id - 1) - 10), (int)0xBBBBBB);
                        continue;
                    }
                    Gui.m_93236_((PoseStack)ms, (Font)fontRenderer, (String)tooltip[id], (int)(posX + 5), (int)(posY + 5 + 12 * id), (int)0xBBBBBB);
                }
            }
        }
    }

    public class GuiTextLabel {
        int x;
        int y;
        String text;

        public GuiTextLabel(int x, int y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }

        public void render(Screen gui, PoseStack ms) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            ((GuiScreenTooltip)GuiScreenTooltip.this).f_96541_.f_91062_.m_92883_(ms, this.text, (float)this.x, (float)this.y, -1);
        }
    }
}

