/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.GuiScreenTooltip;
import net.spellcraftgaming.rpghud.gui.GuiSliderMod;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

public class GuiSettingsModColor
extends GuiScreenTooltip {
    private EditBox colorCodeField;
    private Screen parent;
    private String colorType;
    private int colorR;
    private int colorG;
    private int colorB;
    private int color;
    private String title = "";

    public GuiSettingsModColor(Screen parent, String color, BaseComponent titleIn) {
        super(titleIn);
        this.parent = parent;
        this.colorType = color;
        this.setColors();
        this.title = this.setTitle() + " " + I18n.m_118938_((String)"gui.rpg.editor", (Object[])new Object[0]);
    }

    private String setTitle() {
        return I18n.m_118938_((String)("name." + this.colorType), (Object[])new Object[0]);
    }

    private void setColors() {
        int color;
        this.color = color = ModRPGHud.instance.settings.getIntValue(this.colorType).intValue();
        this.colorR = color >> 16 & 0xFF;
        this.colorG = color >> 8 & 0xFF;
        this.colorB = color & 0xFF;
    }

    private void setSettingColor() {
        ModRPGHud.instance.settings.setSetting(this.colorType, this.color);
    }

    public void m_7856_() {
        int i;
        this.m_142416_((GuiEventListener)new GuiSliderMod(GuiSliderMod.EnumColor.RED, this.f_96543_ / 2 - 75, 40, this.colorR, 0.0f, 255.0f, 1.0f, slider -> slider.m_5716_(0.0, 0.0)));
        this.m_142416_((GuiEventListener)new GuiSliderMod(GuiSliderMod.EnumColor.GREEN, this.f_96543_ / 2 - 75, 65, this.colorG, 0.0f, 255.0f, 1.0f, slider -> slider.m_5716_(0.0, 0.0)));
        this.m_142416_((GuiEventListener)new GuiSliderMod(GuiSliderMod.EnumColor.BLUE, this.f_96543_ / 2 - 75, 90, this.colorB, 0.0f, 255.0f, 1.0f, slider -> slider.m_5716_(0.0, 0.0)));
        this.colorCodeField = new EditBox(this.f_96541_.f_91062_, this.f_96543_ / 2 - 74, 115, 147, 20, (Component)new TranslatableComponent(Settings.intToHexString(this.color)));
        this.colorCodeField.m_94144_(Settings.intToHexString(this.color));
        this.colorCodeField.m_94199_(7);
        this.m_142416_((GuiEventListener)this.colorCodeField);
        String[] colorString = new String[]{"color.red", "color.pink", "color.brown", "color.white", "color.orange", "color.green", "color.purple", "color.blue", "color.aqua", "color.black", "color.grey", "color.yellow"};
        for (i = 0; i < 6; ++i) {
            this.m_142416_((GuiEventListener)new GuiButtonTooltip(10 + i, this.f_96543_ / 4 * 3 - 20, 40 + i * 20, 60, 20, (BaseComponent)new TranslatableComponent(colorString[i]), button -> this.actionPerformed(button)));
        }
        for (i = 0; i < 6; ++i) {
            this.m_142416_((GuiEventListener)new GuiButtonTooltip(16 + i, this.f_96543_ / 4 * 3 + 60 - 20, 40 + i * 20, 60, 20, (BaseComponent)new TranslatableComponent(colorString[i + 6]), button -> this.actionPerformed(button)));
        }
        this.m_142416_((GuiEventListener)new GuiButtonTooltip(this.f_96543_ / 2 - 100, this.f_96544_ / 6 + 168, 125, 20, (BaseComponent)new TranslatableComponent("gui.done"), button -> {
            this.setSettingColor();
            this.f_96541_.m_91152_(this.parent);
        }).setTooltip(I18n.m_118938_((String)"tooltip.done", (Object[])new Object[0])));
        this.m_142416_((GuiEventListener)new GuiButtonTooltip(this.f_96543_ / 2 + 24, this.f_96544_ / 6 + 168, 75, 20, (BaseComponent)new TranslatableComponent("gui.cancel"), button -> this.f_96541_.m_91152_(this.parent)).setTooltip(I18n.m_118938_((String)"tooltip.cancel", (Object[])new Object[0])));
    }

    protected void actionPerformed(Button b) {
        GuiButtonTooltip button = (GuiButtonTooltip)b;
        if (button.f_93623_) {
            if (button.id == 10) {
                this.setColorTo(0xC10000);
            } else if (button.id == 11) {
                this.setColorTo(16738740);
            } else if (button.id == 12) {
                this.setColorTo(9127187);
            } else if (button.id == 13) {
                this.setColorTo(0xF2F2F2);
            } else if (button.id == 14) {
                this.setColorTo(16745472);
            } else if (button.id == 15) {
                this.setColorTo(3916288);
            } else if (button.id == 16) {
                this.setColorTo(10748144);
            } else if (button.id == 17) {
                this.setColorTo(23490);
            } else if (button.id == 18) {
                this.setColorTo(65535);
            } else if (button.id == 19) {
                this.setColorTo(0x292929);
            } else if (button.id == 20) {
                this.setColorTo(0x8A8A8A);
            } else if (button.id == 21) {
                this.setColorTo(0xEEEE00);
            } else if (button.id == 250) {
                this.setSettingColor();
                this.f_96541_.m_91152_(this.parent);
            } else if (button.id == 251) {
                this.f_96541_.m_91152_(this.parent);
            }
        }
    }

    public void setColorTo(int color) {
        this.color = color;
        this.colorR = this.color >> 16 & 0xFF;
        ((GuiSliderMod)((Object)this.m_6702_().get((int)0))).sliderValue = (float)this.colorR / 255.0f;
        ((GuiSliderMod)((Object)this.m_6702_().get((int)0))).value = this.colorR;
        this.colorG = this.color >> 8 & 0xFF;
        ((GuiSliderMod)((Object)this.m_6702_().get((int)1))).sliderValue = (float)this.colorG / 255.0f;
        ((GuiSliderMod)((Object)this.m_6702_().get((int)1))).value = this.colorG;
        this.colorB = this.color & 0xFF;
        ((GuiSliderMod)((Object)this.m_6702_().get((int)2))).sliderValue = (float)this.colorB / 255.0f;
        ((GuiSliderMod)((Object)this.m_6702_().get((int)2))).value = this.colorB;
        this.colorCodeField.m_94144_(Settings.intToHexString(this.color));
    }

    public void m_96624_() {
        super.m_96624_();
        if (this.colorCodeField.m_93696_()) {
            if (!this.colorCodeField.m_94155_().startsWith("#")) {
                Object s = "#" + this.colorCodeField.m_94155_();
                if (this.colorCodeField.m_94155_().length() >= 7) {
                    s = "#";
                    for (int i = 0; i < 6; ++i) {
                        s = (String)s + this.colorCodeField.m_94155_().charAt(i);
                    }
                }
                this.colorCodeField.m_94144_((String)s);
            }
            if (this.colorCodeField.m_94155_().length() == 7 && this.colorCodeField.m_94155_().startsWith("#") && this.colorCodeField.m_94155_().replace("#", "").matches("[0-9A-Fa-f]+")) {
                this.color = Integer.valueOf(this.colorCodeField.m_94155_().replace("#", ""), 16);
                this.colorR = this.color >> 16 & 0xFF;
                ((GuiSliderMod)((Object)this.m_6702_().get((int)0))).sliderValue = (float)this.colorR / 255.0f;
                ((GuiSliderMod)((Object)this.m_6702_().get((int)0))).value = this.colorR;
                this.colorG = this.color >> 8 & 0xFF;
                ((GuiSliderMod)((Object)this.m_6702_().get((int)1))).sliderValue = (float)this.colorG / 255.0f;
                ((GuiSliderMod)((Object)this.m_6702_().get((int)1))).value = this.colorG;
                this.colorB = this.color & 0xFF;
                ((GuiSliderMod)((Object)this.m_6702_().get((int)2))).sliderValue = (float)this.colorB / 255.0f;
                ((GuiSliderMod)((Object)this.m_6702_().get((int)2))).value = this.colorB;
            }
            this.colorCodeField.m_94144_(this.colorCodeField.m_94155_().toUpperCase());
        } else {
            this.colorCodeField.m_94144_(Settings.intToHexString(this.color));
            this.colorR = ((GuiSliderMod)((Object)this.m_6702_().get(0))).getValue();
            this.colorG = ((GuiSliderMod)((Object)this.m_6702_().get(1))).getValue();
            this.colorB = ((GuiSliderMod)((Object)this.m_6702_().get(2))).getValue();
            int color = (this.colorR << 16) + (this.colorG << 8) + this.colorB;
            if (color > 0xFFFFFF) {
                color = 0xFFFFFF;
            }
            if (color < 0) {
                color = 0;
            }
            this.color = color;
        }
        this.colorCodeField.m_94120_();
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.colorCodeField.m_93696_()) {
            this.colorCodeField.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
            if (p_keyPressed_1_ == 28) {
                this.colorCodeField.m_94178_(false);
            }
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.m_6702_()) {
            if (!(child instanceof GuiSliderMod)) continue;
            ((GuiSliderMod)child).dragging = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        Font Font2 = this.f_96541_.f_91062_;
        this.m_7333_(ms);
        Gui.m_93208_((PoseStack)ms, (Font)Font2, (String)this.title, (int)(this.f_96543_ / 2), (int)12, (int)-1);
        Gui.m_93208_((PoseStack)ms, (Font)Font2, (String)I18n.m_118938_((String)"color.red", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)31, (int)-1);
        Gui.m_93208_((PoseStack)ms, (Font)Font2, (String)I18n.m_118938_((String)"color.green", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)56, (int)-1);
        Gui.m_93208_((PoseStack)ms, (Font)Font2, (String)I18n.m_118938_((String)"color.blue", (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)81, (int)-1);
        this.colorCodeField.m_6305_(ms, mouseX, mouseY, partialTicks);
        Gui.m_93208_((PoseStack)ms, (Font)Font2, (String)(I18n.m_118938_((String)"gui.rpg.result", (Object[])new Object[0]) + ": " + Settings.intToHexString(this.color)), (int)(this.f_96543_ / 2), (int)141, (int)-1);
        super.m_6305_(ms, mouseX, mouseY, partialTicks);
        HudElement.drawCustomBar(ms, this.f_96543_ / 2 - 75, 149, 150, 16, 100.0, 0, 0, this.color, HudElement.offsetColorPercent(this.color, 25), true);
    }
}

