/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.settings.Settings;

@Environment(value=EnvType.CLIENT)
public abstract class HudElement {
    public static final int COLOR_RED = 0xC10000;
    public static final int COLOR_PINK = 16738740;
    public static final int COLOR_BROWN = 9127187;
    public static final int COLOR_WHITE = 0xF2F2F2;
    public static final int COLOR_ORANGE = 16745472;
    public static final int COLOR_GREEN = 3916288;
    public static final int COLOR_PURPLE = 10748144;
    public static final int COLOR_BLUE = 23490;
    public static final int COLOR_AQUA = 65535;
    public static final int COLOR_BLACK = 0x292929;
    public static final int COLOR_GREY = 0x8A8A8A;
    public static final int COLOR_YELLOW = 0xEEEE00;
    public static final int[] COLOR_DEFAULT = new int[]{0x4C4C4C, 0x3D3D3D};
    protected static final class_2960 INTERFACE = new class_2960("rpghud:textures/interface.png");
    public static final int OFFSET_PERCENT = 25;
    public static final int OFFSET_PREVIEW = 0x5A5A5A;
    protected int posX;
    protected int posY;
    protected final int defaultPosX;
    protected final int defaultPosY;
    protected int elementWidth;
    protected int elementHeight;
    protected boolean moveable;
    protected HudElementType type;
    protected class_310 mc;
    protected ModRPGHud rpgHud;
    protected Settings settings;
    protected float scale;
    protected float scaleInverted;
    public HudElementType parent;

    public HudElement(HudElementType type, int posX, int posY, int width, int height, boolean moveable) {
        this.type = type;
        this.posX = posX;
        this.posY = posY;
        this.defaultPosX = posX;
        this.defaultPosY = posY;
        this.elementWidth = width;
        this.elementHeight = height;
        this.moveable = moveable;
        this.mc = class_310.method_1551();
        this.rpgHud = ModRPGHud.instance;
        this.settings = this.rpgHud.settings;
        this.scale = 1.0f;
        this.scaleInverted = 1.0f / this.scale;
        this.parent = type;
    }

    public void draw(class_332 gui, class_4587 ms, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        this.drawElement(gui, ms, zLevel, partialTicks, scaledWidth, scaledHeight);
    }

    public abstract void drawElement(class_332 var1, class_4587 var2, float var3, float var4, int var5, int var6);

    public int getPosX(int scaledWidth) {
        return this.posX;
    }

    public int getPosY(int scaledHeight) {
        return this.posY;
    }

    public int getWidth(int scaledWidth) {
        return this.elementWidth;
    }

    public int getHeight(int scaledHeight) {
        return this.elementHeight;
    }

    public float getScale() {
        return 1.0f;
    }

    public float getInvertedScale() {
        return 1.0f / this.getScale();
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public HudElementType getType() {
        return this.type;
    }

    public boolean setPos(int posX, int posY) {
        boolean xValid = false;
        boolean yValid = false;
        if (posX >= 0 && posX < this.mc.method_22683().method_4486() - this.elementWidth) {
            xValid = true;
        }
        if (posY >= 0 && posY < this.mc.method_22683().method_4502() - this.elementHeight) {
            yValid = true;
        }
        if (xValid && yValid) {
            this.posX = posX;
            this.posY = posY;
        }
        return xValid && yValid;
    }

    public void setPositionToDefault() {
        this.posX = this.defaultPosX;
        this.posY = this.defaultPosY;
    }

    public boolean checkConditions() {
        return true;
    }

    public static void drawRect(class_4587 ms, int posX, int posY, int width, int height, int color) {
        if (color == -1) {
            return;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        class_287 vertexbuffer = class_289.method_1348().method_1349();
        vertexbuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        vertexbuffer.method_22918(ms.method_23760().method_23761(), (float)posX, (float)(posY + height), 0.0f).method_22915(f, f1, f2, f3).method_1344();
        vertexbuffer.method_22918(ms.method_23760().method_23761(), (float)(posX + width), (float)(posY + height), 0.0f).method_22915(f, f1, f2, f3).method_1344();
        vertexbuffer.method_22918(ms.method_23760().method_23761(), (float)(posX + width), (float)posY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        vertexbuffer.method_22918(ms.method_23760().method_23761(), (float)posX, (float)posY, 0.0f).method_22915(f, f1, f2, f3).method_1344();
        class_286.method_43433((class_287.class_7433)vertexbuffer.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    protected static void drawOutline(class_4587 ms, int x, int y, int width, int height, int color) {
        HudElement.drawRect(ms, x, y, width, 1, color);
        HudElement.drawRect(ms, x, y + 1, 1, height - 2, color);
        HudElement.drawRect(ms, x + width - 1, y + 1, 1, height - 2, color);
        HudElement.drawRect(ms, x, y + height - 1, width, 1, color);
    }

    public static void drawCustomBar(class_4587 ms, int x, int y, int width, int height, double value, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, COLOR_DEFAULT[0], COLOR_DEFAULT[1], colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(class_4587 ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, 0);
    }

    public static void drawCustomBar(class_4587 ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, outlined, 0);
    }

    public static void drawCustomBar(class_4587 ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, int colorOutline) {
        HudElement.drawCustomBar(ms, x, y, width, height, value, colorGroundLight, colorGroundDark, colorBarLight, colorBarDark, true, colorOutline);
    }

    public static void drawCustomBar(class_4587 ms, int x, int y, int width, int height, double value, int colorGroundLight, int colorGroundDark, int colorBarLight, int colorBarDark, boolean outlined, int colorOutline) {
        if (value < 0.0) {
            value = 0.0;
        } else if (value > 100.0) {
            value = 100.0;
        }
        int offset = 0;
        if (outlined) {
            offset = 1;
        }
        int filledWidth = width;
        filledWidth = width - offset * 2;
        if (filledWidth < 0) {
            filledWidth = 0;
        }
        int filledHeight = width;
        filledHeight = height - offset * 2;
        if (filledHeight < 0) {
            filledHeight = 0;
        }
        int percentFilled = (int)Math.round(value / 100.0 * (double)filledWidth);
        if (outlined) {
            HudElement.drawOutline(ms, x, y, width, height, colorOutline);
        }
        int halfedFilledHeight = filledHeight / 2;
        HudElement.drawRect(ms, x + offset, y + offset, percentFilled, halfedFilledHeight, colorBarLight);
        HudElement.drawRect(ms, x + offset, y + offset + halfedFilledHeight, percentFilled, filledHeight - halfedFilledHeight, colorBarDark);
        if (filledWidth - percentFilled > 0) {
            HudElement.drawRect(ms, x + offset + percentFilled, y + offset, filledWidth - percentFilled, halfedFilledHeight, colorGroundLight);
            HudElement.drawRect(ms, x + offset + percentFilled, y + offset + halfedFilledHeight, filledWidth - percentFilled, filledHeight - halfedFilledHeight, colorGroundDark);
        }
    }

    public void drawTetragon(int posX1, int posX2, int posY1, int posY2, int width1, int width2, int height1, int height2, int color) {
        if (color == -1) {
            return;
        }
        if (width1 < 0) {
            width1 = 0;
        }
        if (width2 < 0) {
            width2 = 0;
        }
        float f3 = color <= 0xFFFFFF && color >= 0 ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.disableDepthTest();
        class_287 vertexbuffer = class_289.method_1348().method_1349();
        vertexbuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        vertexbuffer.method_22912((double)posX1, (double)posY1 + (double)height1, 0.0).method_22915(f, f1, f2, f3).method_1344();
        vertexbuffer.method_22912((double)posX2 + (double)width2, (double)posY2 + (double)height2, 0.0).method_22915(f, f1, f2, f3).method_1344();
        vertexbuffer.method_22912((double)posX1 + (double)width1, (double)posY2, 0.0).method_22915(f, f1, f2, f3).method_1344();
        vertexbuffer.method_22912((double)posX2, (double)posY1, 0.0).method_22915(f, f1, f2, f3).method_1344();
        class_286.method_43433((class_287.class_7433)vertexbuffer.method_1326());
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static int offsetColorPercent(int color, int offsetPercent) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart -= colorPart / (100 / offsetPercent)) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        colorPart -= colorPart / (100 / offsetPercent);
        if (colorPart > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    public static int offsetColor(int color, int offset) {
        int colorPart = color >> 16 & 0xFF;
        if ((colorPart += offset >> 16 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        int colorOffset = colorPart << 16;
        colorPart = color >> 8 & 0xFF;
        if ((colorPart += offset >> 8 & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        colorOffset += colorPart << 8;
        colorPart = color & 0xFF;
        if ((colorPart += offset & 0xFF) > 255) {
            colorPart = 255;
        } else if (colorPart < 0) {
            colorPart = 0;
        }
        return colorOffset += colorPart;
    }

    protected void bind(class_2960 res) {
        RenderSystem.setShaderTexture((int)0, (class_2960)res);
    }

    protected static class_2960 getPlayerSkin(class_746 player) {
        return player.method_3117();
    }

    protected void renderHotbarItem(int x, int y, float partialTicks, class_1657 player, class_1799 item) {
        if (!item.method_7960()) {
            class_4587 matrixStack = RenderSystem.getModelViewStack();
            float f = (float)item.method_7965() - partialTicks;
            if (f > 0.0f) {
                matrixStack.method_22903();
                float f1 = 1.0f + f / 5.0f;
                matrixStack.method_22904((double)(x + 8), (double)(y + 12), 0.0);
                matrixStack.method_22905(1.0f / f1, (f1 + 1.0f) / 2.0f, 1.0f);
                matrixStack.method_22904((double)(-(x + 8)), (double)(-(y + 12)), 0.0);
            }
            this.mc.method_1480().method_4023(item, x, y);
            if (f > 0.0f) {
                matrixStack.method_22909();
            }
            this.mc.method_1480().method_4025(this.mc.field_1772, item, x, y);
        }
    }

    protected void drawStringWithBackground(class_4587 ms, String text, int posX, int posY, int colorMain, int colorBackground) {
        this.mc.field_1772.method_1729(ms, text, (float)(posX + 1), (float)posY, colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)(posX - 1), (float)posY, colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)posX, (float)(posY + 1), colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)posX, (float)(posY - 1), colorBackground);
        this.mc.field_1772.method_1729(ms, text, (float)posX, (float)posY, colorMain);
        RenderSystem.enableBlend();
    }

    public boolean isChatOpen() {
        return this.mc.field_1755 instanceof class_408;
    }
}

