/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.modern.HudElementHotbarModern;

public class GuiSliderMod
extends GuiButtonTooltip {
    private EnumColor color;
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    private final float valueStep;
    public int value;
    public ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, Button.OnPress titleIn) {
        this(color, x, y, value, minValueIn, maxValue, valueStep, null, titleIn);
    }

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, ISlider par, Button.OnPress titleIn) {
        super(x, y, 150, 12, (Component)Component.m_237115_((String)""), titleIn);
        this.color = color;
        this.sliderValue = value / 255.0f;
        this.value = (int)Math.ceil(value);
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        if (this.showDecimal) {
            String val = Double.toString(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            String val = Integer.toString((int)Math.round(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        if (!this.drawString) {
            this.dispString = "";
        }
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.dragging = false;
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public int getValue() {
        return (int)Math.ceil(this.value);
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.sliderValue = Math.ceil(Mth.m_14008_((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
        this.updateSlider(mouseX, mouseY);
        this.dragging = true;
    }

    public void updateSlider(double mouseX, double mouseY) {
        this.sliderValue = (float)(mouseX - (double)(this.f_93620_ + 4)) / (float)(this.f_93618_ - 8);
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        this.value = Mth.m_14165_((double)Mth.m_14008_((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
    }

    private String getDisplayString() {
        return "#" + Integer.toHexString(this.getValue()).toUpperCase();
    }

    @Override
    public void m_6305_(PoseStack ms, int mouseX, int mouseY, float partial) {
        if (this.f_93624_) {
            if (this.dragging) {
                this.updateSlider(mouseX, mouseY);
            }
            Minecraft mc = Minecraft.m_91087_();
            int color = 0 + (this.color == EnumColor.RED ? this.value << 16 : (this.color == EnumColor.GREEN ? this.value << 8 : this.value));
            HudElement.drawCustomBar(ms, this.f_93620_, this.f_93621_, this.f_93618_, this.f_93619_, 100.0, color, HudElement.offsetColorPercent(color, 25));
            color = 0xE0E0E0;
            if (!this.f_93623_) {
                color = 0xA0A0A0;
            } else if (this.f_93622_) {
                color = 0xFFFFA0;
            }
            String buttonText = this.getDisplayString();
            RenderSystem.m_157456_((int)0, (ResourceLocation)HudElementHotbarModern.WIDGETS_TEX_PATH);
            this.m_93228_(ms, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)), this.f_93621_, 0, 66, 4, this.f_93619_ / 2);
            this.m_93228_(ms, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)), this.f_93621_ + this.f_93619_ / 2, 0, 86 - this.f_93619_ / 2, 4, this.f_93619_ / 2);
            this.m_93228_(ms, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)) + 4, this.f_93621_, 196, 66, 4, this.f_93619_ / 2);
            this.m_93228_(ms, this.f_93620_ + (int)(this.sliderValue * (double)(this.f_93618_ - 8)) + 4, this.f_93621_ + this.f_93619_ / 2, 196, 86 - this.f_93619_ / 2, 4, this.f_93619_ / 2);
            Gui.m_93208_((PoseStack)ms, (Font)mc.f_91062_, (String)buttonText, (int)(this.f_93620_ + this.f_93618_ / 2), (int)(this.f_93621_ + (this.f_93619_ - 8) / 2), (int)color);
        }
    }

    public float normalizeValue(float value) {
        return (float)Mth.m_14008_((double)(((double)this.snapToStepClamp(value) - this.maxValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp((float)(this.minValue + (this.maxValue - this.minValue) * (double)Mth.m_14036_((float)value, (float)0.0f, (float)1.0f)));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return (float)Mth.m_14008_((double)value, (double)this.minValue, (double)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public static enum EnumColor {
        RED,
        GREEN,
        BLUE;

    }

    public static interface ISlider {
        public void onChangeSliderValue(GuiSliderMod var1);
    }
}

