/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.modern;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spellcraftgaming.rpghud.gui.hud.element.vanilla.HudElementClockVanilla;

public class HudElementClockModern
extends HudElementClockVanilla {
    public HudElementClockModern() {
        this.posX = 0;
        this.posY = 0;
        this.elementWidth = 0;
        this.elementHeight = 0;
        this.moveable = true;
    }

    @Override
    public boolean checkConditions() {
        return this.settings.getBoolValue("enable_clock") != false && !this.mc.f_91066_.f_92063_ && (this.settings.getBoolValue("enable_immersive_clock") == false || this.mc.f_91074_.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42524_)));
    }

    @Override
    public void drawElement(Gui gui, PoseStack ms, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        float scale = this.getScale();
        ms.m_85841_(scale, scale, scale);
        int yOffset = this.getPosY(scaledHeight);
        int xOffset = this.getPosX(scaledWidth);
        int clockColor = 0xFFFFFF;
        int width = this.getWidth(scaledWidth);
        int height = this.getHeight(scaledHeight);
        if (this.settings.getBoolValue("enable_clock_color").booleanValue()) {
            clockColor = this.getClockColor();
        }
        HudElementClockModern.drawRect(ms, xOffset, yOffset, width, height, -1610612736);
        Gui.m_93208_((PoseStack)ms, (Font)this.mc.f_91062_, (String)this.getTime(), (int)(xOffset + width / 2), (int)(yOffset + 2), (int)clockColor);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        scale = this.getInvertedScale();
        ms.m_85841_(scale, scale, scale);
    }

    @Override
    public int getPosX(int scaledWidth) {
        return (int)((float)this.settings.getPositionValue("clock_position")[0] + (float)("2" + this.settings.getStringValue("clock_time_format") == "time.24" ? 0 : 2) * this.getInvertedScale());
    }

    @Override
    public int getPosY(int scaledHeight) {
        return (int)((float)((this.settings.getBoolValue("render_player_face") != false ? 0 : 8) + (this.settings.getBoolValue("show_numbers_health") != false && this.settings.getBoolValue("show_numbers_food") != false ? 0 : 4) + 23) * this.getInvertedScale() + (float)this.settings.getPositionValue("clock_position")[1]);
    }

    @Override
    public int getWidth(int scaledWidth) {
        return this.settings.getStringValue("clock_time_format") == "time.24" ? 40 : 46;
    }

    @Override
    public int getHeight(int scaledHeight) {
        return 12;
    }

    @Override
    public float getScale() {
        return 0.5f;
    }
}

