/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.spellcraftgaming.rpghud.gui.hud.Hud;
import net.spellcraftgaming.rpghud.gui.hud.HudDefault;
import net.spellcraftgaming.rpghud.gui.hud.HudExtendedWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudFullTexture;
import net.spellcraftgaming.rpghud.gui.hud.HudModern;
import net.spellcraftgaming.rpghud.gui.hud.HudSimple;
import net.spellcraftgaming.rpghud.gui.hud.HudVanilla;
import net.spellcraftgaming.rpghud.main.RenderOverlay;
import net.spellcraftgaming.rpghud.settings.Settings;

@Environment(value=EnvType.CLIENT)
public class ModRPGHud
implements ClientModInitializer {
    public final String MODID = "rpg-hud";
    public static ModRPGHud instance;
    public static boolean[] renderDetailsAgain;
    public static int screenOffset;
    public Settings settings;
    public Map<String, Hud> huds = new LinkedHashMap<String, Hud>();

    public void onInitializeClient() {
        instance = this;
        this.settings = new Settings();
        this.registerHud(new HudVanilla(class_310.method_1551(), "vanilla", "Vanilla"));
        this.registerHud(new HudSimple(class_310.method_1551(), "simple", "Simplified"));
        this.registerHud(new HudDefault(class_310.method_1551(), "default", "Default"));
        this.registerHud(new HudExtendedWidget(class_310.method_1551(), "extended", "Extended Widget"));
        this.registerHud(new HudFullTexture(class_310.method_1551(), "texture", "Full Texture"));
        this.registerHud(new HudModern(class_310.method_1551(), "modern", "Modern Style"));
        if (!this.isHudKeyValid(this.settings.getStringValue("hud_type"))) {
            this.settings.setSetting("hud_type", "vanilla");
        }
        new RenderOverlay();
        if (ModRPGHud.isClass("io.github.prospector.modmenu.ModMenu")) {
            screenOffset = 12;
        }
    }

    public void registerHud(Hud hud) {
        this.huds.put(hud.getHudKey(), hud);
    }

    public Hud getActiveHud() {
        return this.huds.get(this.settings.getStringValue("hud_type"));
    }

    public Hud getVanillaHud() {
        return this.huds.get("vanilla");
    }

    public boolean isVanillaHud() {
        return this.settings.getStringValue("hud_type") == "vanilla";
    }

    public boolean isHudKeyValid(String key) {
        return this.huds.containsKey(key);
    }

    public static boolean isClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        renderDetailsAgain = new boolean[]{false, false, false};
        screenOffset = 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum HeartTypeNew {
        CONTAINER(0, false),
        NORMAL(2, true),
        POISONED(4, true),
        WITHERED(6, true),
        ABSORBING(8, false),
        FROZEN(9, false);

        private final int textureIndex;
        private final boolean hasBlinkingTexture;

        private HeartTypeNew(int textureIndex, boolean hasBlinkingTexture) {
            this.textureIndex = textureIndex;
            this.hasBlinkingTexture = hasBlinkingTexture;
        }

        public int getU(boolean halfHeart, boolean blinking) {
            int i;
            if (this == CONTAINER) {
                i = blinking ? 1 : 0;
            } else {
                int j = halfHeart ? 1 : 0;
                int k = this.hasBlinkingTexture && blinking ? 2 : 0;
                i = j + k;
            }
            return 16 + (this.textureIndex * 2 + i) * 9;
        }

        public static HeartTypeNew fromPlayerState(class_1657 player) {
            HeartTypeNew heartType = player.method_6059(class_1294.field_5899) ? POISONED : (player.method_6059(class_1294.field_5920) ? WITHERED : (player.method_32314() ? FROZEN : NORMAL));
            return heartType;
        }
    }
}

