/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class GuiScreenTooltip
extends Screen {
    protected List<GuiTextLabel> labelList = new ArrayList<GuiTextLabel>();

    protected GuiScreenTooltip(Component titleIn) {
        super(titleIn);
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(gg, mouseX, mouseY, partialTicks);
        for (GuiTextLabel label : this.labelList) {
            label.render(this, gg);
        }
        if (ModRPGHud.instance.settings.getBoolValue("enable_button_tooltip").booleanValue()) {
            this.drawTooltip(gg, mouseX, mouseY);
        }
    }

    private void drawTooltip(GuiGraphics gg, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.m_91087_();
        Font fontRenderer = mc.f_91062_;
        GuiScreenTooltip gui = null;
        if (!(mc.f_91080_ instanceof GuiScreenTooltip)) {
            return;
        }
        gui = (GuiScreenTooltip)mc.f_91080_;
        boolean shouldRenderTooltip = false;
        GuiButtonTooltip button = null;
        for (int x = 0; x < this.m_6702_().size(); ++x) {
            GuiEventListener b = (GuiEventListener)this.m_6702_().get(x);
            if (b instanceof GuiButtonTooltip) {
                button = (GuiButtonTooltip)b;
            }
            if (button == null || !button.m_198029_()) continue;
            shouldRenderTooltip = true;
            break;
        }
        if (shouldRenderTooltip) {
            int posX = mouseX + 5;
            int posY = mouseY + 5;
            int totalWidth = 0;
            boolean reverseY = false;
            String[] tooltip = button.getTooltipNew();
            if (tooltip != null) {
                int id;
                int counter = 0;
                for (id = 0; id < tooltip.length; ++id) {
                    int width = fontRenderer.m_92895_(tooltip[id]);
                    if (totalWidth < width) {
                        totalWidth = fontRenderer.m_92895_(tooltip[id]);
                    }
                    ++counter;
                }
                if ((posX -= totalWidth / 2) + totalWidth + 10 > gui.f_96543_) {
                    posX -= posX + totalWidth + 10 - gui.f_96543_;
                }
                if (posX < 0) {
                    posX = 0;
                }
                if (posY + 3 + tooltip.length * 12 + 2 > gui.f_96544_) {
                    reverseY = true;
                }
                if (reverseY) {
                    HudElement.drawRect(gg, posX, posY - 3 - tooltip.length * 12 - 2, totalWidth + 10, 3 + tooltip.length * 12 + 2, -1073741824);
                } else {
                    HudElement.drawRect(gg, posX, posY, totalWidth + 10, 3 + tooltip.length * 12 + 2, -1073741824);
                }
                for (id = 0; id < tooltip.length; ++id) {
                    if (tooltip[id].isEmpty()) continue;
                    if (reverseY) {
                        gg.m_280488_(fontRenderer, tooltip[id], posX + 5, posY - 2 - 12 * (counter - id - 1) - 10, 0xBBBBBB);
                        continue;
                    }
                    gg.m_280488_(fontRenderer, tooltip[id], posX + 5, posY + 5 + 12 * id, 0xBBBBBB);
                }
            }
        }
    }

    public class GuiTextLabel {
        int x;
        int y;
        String text;

        public GuiTextLabel(int x, int y, String text) {
            this.x = x;
            this.y = y;
            this.text = text;
        }

        public void render(Screen gui, GuiGraphics gg) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            gg.m_280488_(((GuiScreenTooltip)GuiScreenTooltip.this).f_96541_.f_91062_, this.text, this.x, this.y, -1);
        }
    }
}

