/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.modern;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spellcraftgaming.rpghud.gui.hud.element.vanilla.HudElementClockVanilla;

public class HudElementClockModern
extends HudElementClockVanilla {
    public HudElementClockModern() {
        this.posX = 0;
        this.posY = 0;
        this.elementWidth = 0;
        this.elementHeight = 0;
        this.moveable = true;
    }

    @Override
    public boolean checkConditions() {
        return this.settings.getBoolValue("enable_clock") != false && !this.mc.f_91066_.f_92063_ && (this.settings.getBoolValue("enable_immersive_clock") == false || this.mc.f_91074_.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42524_)));
    }

    @Override
    public void drawElement(GuiGraphics gg, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        float scale = this.getScale();
        gg.m_280168_().m_85841_(scale, scale, scale);
        int yOffset = this.getPosY(scaledHeight);
        int xOffset = this.getPosX(scaledWidth);
        int clockColor = 0xFFFFFF;
        int width = this.getWidth(scaledWidth);
        int height = this.getHeight(scaledHeight);
        if (this.settings.getBoolValue("enable_clock_color").booleanValue()) {
            clockColor = this.getClockColor();
        }
        HudElementClockModern.drawRect(gg, xOffset, yOffset, width, height, -1610612736);
        gg.m_280137_(this.mc.f_91062_, this.getTime(), xOffset + width / 2, yOffset + 2, clockColor);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        scale = this.getInvertedScale();
        gg.m_280168_().m_85841_(scale, scale, scale);
    }

    @Override
    public int getPosX(int scaledWidth) {
        return (int)((float)this.settings.getPositionValue("clock_position")[0] + (float)("2" + this.settings.getStringValue("clock_time_format") == "time.24" ? 0 : 2) * this.getInvertedScale());
    }

    @Override
    public int getPosY(int scaledHeight) {
        return (int)((float)((this.settings.getBoolValue("render_player_face") != false ? 0 : 8) + (this.settings.getBoolValue("show_numbers_health") != false && this.settings.getBoolValue("show_numbers_food") != false ? 0 : 4) + 23) * this.getInvertedScale() + (float)this.settings.getPositionValue("clock_position")[1]);
    }

    @Override
    public int getWidth(int scaledWidth) {
        return this.settings.getStringValue("clock_time_format") == "time.24" ? 40 : 46;
    }

    @Override
    public int getHeight(int scaledHeight) {
        return 12;
    }

    @Override
    public float getScale() {
        return 0.5f;
    }
}

