/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.vanilla;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementClockVanilla
extends HudElement {
    public HudElementClockVanilla() {
        super(HudElementType.CLOCK, 0, 0, 0, 0, true);
    }

    @Override
    public boolean checkConditions() {
        return super.checkConditions() && this.settings.getBoolValue("enable_clock") != false && !this.mc.f_91066_.f_92063_ && (this.settings.getBoolValue("enable_immersive_clock") == false || this.mc.f_91074_.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42524_)));
    }

    @Override
    public void drawElement(GuiGraphics gg, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        int clockColor = 0xFFFFFF;
        if (this.settings.getBoolValue("enable_clock_color").booleanValue()) {
            clockColor = this.getClockColor();
        }
        if (this.settings.getBoolValue("reduce_size").booleanValue()) {
            gg.m_280168_().m_85841_(0.5f, 0.5f, 0.5f);
        }
        gg.m_280488_(this.mc.f_91062_, this.getTime(), (this.settings.getBoolValue("reduce_size") != false ? 8 : 4) + this.settings.getPositionValue("clock_position")[0], (this.settings.getBoolValue("reduce_size") != false ? 104 : 52) + this.settings.getPositionValue("clock_position")[1], clockColor);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.settings.getBoolValue("reduce_size").booleanValue()) {
            gg.m_280168_().m_85841_(2.0f, 2.0f, 2.0f);
        }
    }

    public String getTime() {
        long time = this.mc.f_91074_.m_9236_().m_46468_();
        long day = this.mc.f_91074_.m_9236_().m_46468_() / 24000L;
        long currentTime = time - 24000L * day;
        long currentHour = currentTime / 1000L + 6L;
        double currentTimeMin = currentTime - (currentHour - 6L) * 1000L;
        int currentMin = (int)(currentTimeMin /= 16.666666666666668);
        if (currentHour > 24L) {
            currentHour -= 24L;
        }
        if (this.settings.getStringValue("clock_time_format") == "time.24") {
            return HudElementClockVanilla.get24HourTimeForString(currentHour, currentMin);
        }
        return HudElementClockVanilla.get12HourTimeForString(currentHour, currentMin);
    }

    public static String get24HourTimeForString(long currentHour, long currentMin) {
        StringBuilder sb = new StringBuilder();
        if (currentHour == 24L) {
            currentHour = 0L;
        }
        if (currentHour < 10L) {
            sb.append("0");
        }
        sb.append(currentHour);
        return sb.toString() + ":" + HudElementClockVanilla.getMinuteForString(currentMin);
    }

    public static String get12HourTimeForString(long currentHour, long currentMin) {
        StringBuilder sb = new StringBuilder();
        String period = "am";
        if (currentHour == 12L) {
            period = "pm";
        }
        if (currentHour == 24L) {
            currentHour = 12L;
            period = "am";
        }
        if (currentHour > 12L) {
            currentHour -= 12L;
            period = "pm";
        }
        if (currentHour < 10L) {
            sb.append(0);
        }
        sb.append(currentHour);
        return sb.toString() + ":" + HudElementClockVanilla.getMinuteForString(currentMin) + " " + period;
    }

    public static String getMinuteForString(long currentMin) {
        StringBuilder sb = new StringBuilder();
        if (currentMin < 10L) {
            sb.append("0");
        }
        sb.append(currentMin);
        return sb.toString();
    }

    public int getClockColor() {
        long day;
        long time = this.mc.f_91074_.m_9236_().m_46468_();
        long currentTime = time - 24000L * (day = this.mc.f_91074_.m_9236_().m_46468_() / 24000L);
        if (currentTime < 1000L) {
            return 0xFFAF00;
        }
        if (currentTime < 6000L) {
            return 0xFFAF00;
        }
        if (currentTime < 11000L) {
            return 0xFFCF00;
        }
        if (currentTime < 12000L) {
            return 0xFFAF00;
        }
        if (currentTime < 13000L) {
            return 16753152;
        }
        if (currentTime < 13500L) {
            return 14904865;
        }
        if (currentTime < 18000L) {
            return 3431796;
        }
        if (currentTime < 21000L) {
            return 2046023;
        }
        if (currentTime < 22250L) {
            return 3431796;
        }
        if (currentTime < 22500L) {
            return 7822708;
        }
        if (currentTime < 23000L) {
            return 14904865;
        }
        return 16753152;
    }
}

