/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.spellcraftgaming.rpghud.event.ClientEventHandler;
import net.spellcraftgaming.rpghud.gui.hud.Hud;
import net.spellcraftgaming.rpghud.gui.hud.HudDefault;
import net.spellcraftgaming.rpghud.gui.hud.HudExtendedWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudFullTexture;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudModern;
import net.spellcraftgaming.rpghud.gui.hud.HudSimple;
import net.spellcraftgaming.rpghud.gui.hud.HudVanilla;
import net.spellcraftgaming.rpghud.main.RenderOverlay;
import net.spellcraftgaming.rpghud.settings.Settings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rpghud")
public class ModRPGHud {
    public static ModRPGHud instance;
    public static boolean[] renderDetailsAgain;
    public Settings settings;
    public Map<String, Hud> huds = new LinkedHashMap<String, Hud>();
    public static final Logger LOGGER;

    public ModRPGHud() {
        instance = this;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        } else {
            LOGGER.warn("RPG-Hud is a client-side-only mod and should not be installed server-side, please remove it from your server");
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        this.settings = new Settings();
        this.registerHud(new HudVanilla(Minecraft.m_91087_(), "vanilla", "Vanilla"));
        this.registerHud(new HudSimple(Minecraft.m_91087_(), "simple", "Simplified"));
        this.registerHud(new HudDefault(Minecraft.m_91087_(), "default", "Default"));
        this.registerHud(new HudExtendedWidget(Minecraft.m_91087_(), "extended", "Extended Widget"));
        this.registerHud(new HudFullTexture(Minecraft.m_91087_(), "texture", "Full Texture"));
        this.registerHud(new HudHotbarWidget(Minecraft.m_91087_(), "hotbar", "Hotbar Widget"));
        this.registerHud(new HudModern(Minecraft.m_91087_(), "modern", "Modern Style"));
        if (!this.isHudKeyValid(this.settings.getStringValue("hud_type"))) {
            this.settings.setSetting("hud_type", "vanilla");
        }
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        ClientEventHandler.init();
    }

    public void registerHud(Hud hud) {
        this.huds.put(hud.getHudKey(), hud);
    }

    public Hud getActiveHud() {
        return this.huds.get(this.settings.getStringValue("hud_type"));
    }

    public Hud getVanillaHud() {
        return this.huds.get("vanilla");
    }

    public boolean isVanillaHud() {
        return this.settings.getStringValue("hud_type") == "vanilla";
    }

    public boolean isHudKeyValid(String key) {
        return this.huds.containsKey(key);
    }

    static {
        renderDetailsAgain = new boolean[]{false, false, false};
        LOGGER = LogManager.getLogger();
    }

    @Mod.EventBusSubscriber(modid="rpghud", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll("rpghud", (IGuiOverlay)new RenderOverlay());
        }
    }
}

