/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.spellcraftgaming.rpghud.gui.hud.HudHotbarWidget;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

public class RenderOverlay
implements IGuiOverlay {
    private ModRPGHud rpgHud = ModRPGHud.instance;
    private Minecraft mc = Minecraft.m_91087_();

    public RenderOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void render(ForgeGui forgeGui, GuiGraphics gg, float partialTicks, int screenWidth, int screenHeight) {
        this.drawElement(HudElementType.WIDGET, gg, partialTicks);
        this.drawElement(HudElementType.CLOCK, gg, partialTicks);
        this.drawElement(HudElementType.DETAILS, gg, partialTicks);
        this.drawElement(HudElementType.COMPASS, gg, partialTicks);
        this.drawElement(HudElementType.ENTITY_INSPECT, gg, partialTicks);
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH)) {
            this.drawElement(HudElementType.HEALTH, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.ARMOR)) {
            this.drawElement(HudElementType.ARMOR, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.FOOD)) {
            this.drawElement(HudElementType.FOOD, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH_MOUNT)) {
            this.drawElement(HudElementType.HEALTH_MOUNT, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.AIR)) {
            this.drawElement(HudElementType.AIR, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.JUMP_BAR)) {
            this.drawElement(HudElementType.JUMP_BAR, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.STATUS_EFFECTS)) {
            this.drawElement(HudElementType.STATUS_EFFECTS, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.EXPERIENCE)) {
            this.drawElement(HudElementType.EXPERIENCE, gg, partialTicks);
            this.drawElement(HudElementType.LEVEL, gg, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HOTBAR)) {
            this.drawElement(HudElementType.HOTBAR, gg, partialTicks);
        }
        this.drawElement(HudElementType.MISC, gg, partialTicks);
    }

    @SubscribeEvent
    public void registerOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("rpg_hud", (IGuiOverlay)this);
    }

    private void drawElement(HudElementType type, GuiGraphics gg, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type) && !this.preventElementRenderType(type)) {
            gg.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            this.rpgHud.getActiveHud().drawElement(type, gg, 0.0f, partialTicks, this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_());
            gg.m_280168_().m_85849_();
        }
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean shouldRenderVanilla(HudElementType type) {
        return RenderOverlay.isVanillaElement(type) || RenderOverlay.forceRenderTypeVanilla(type);
    }

    public static boolean forceRenderTypeVanilla(HudElementType type) {
        ModRPGHud rpgHud = ModRPGHud.instance;
        String id = "render_vanilla_" + type.name().toLowerCase();
        if (rpgHud.settings.doesSettingExist(id)) {
            return rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean preventEventType(HudElementType type) {
        if (!RenderOverlay.shouldRenderVanilla(type)) {
            return true;
        }
        ModRPGHud rpgHud = ModRPGHud.instance;
        String id = "prevent_event_" + type.name().toLowerCase();
        if (rpgHud.settings.doesSettingExist(id)) {
            return rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean isVanillaElement(HudElementType type) {
        return ModRPGHud.instance.getActiveHud().isVanillaElement(type);
    }

    @SubscribeEvent
    public void onGameOverlayRenderPre(RenderGuiOverlayEvent.Pre event) {
        ResourceLocation overlay = event.getOverlay().id();
        if (VanillaGuiOverlay.AIR_LEVEL.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.AIR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.ARMOR_LEVEL.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.ARMOR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.EXPERIENCE_BAR.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.EXPERIENCE)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.FOOD_LEVEL.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.FOOD)) {
                event.setCanceled(true);
            }
        } else if (overlay == VanillaGuiOverlay.PLAYER_HEALTH.id()) {
            if (RenderOverlay.preventEventType(HudElementType.HEALTH)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.MOUNT_HEALTH.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.HEALTH_MOUNT)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.HOTBAR.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.HOTBAR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.JUMP_BAR.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.JUMP_BAR)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.POTION_ICONS.id() == overlay) {
            if (RenderOverlay.preventEventType(HudElementType.STATUS_EFFECTS)) {
                event.setCanceled(true);
            }
        } else if (VanillaGuiOverlay.CHAT_PANEL.id() == overlay && ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            event.getGuiGraphics().m_280168_().m_252880_(0.0f, -22.0f, 0.0f);
        }
    }

    @SubscribeEvent
    public void onGameOverlayRenderPost(RenderGuiOverlayEvent.Post event) {
        ResourceLocation overlay = event.getOverlay().id();
        if (VanillaGuiOverlay.CHAT_PANEL.id() == overlay && ModRPGHud.instance.getActiveHud() instanceof HudHotbarWidget) {
            event.getGuiGraphics().m_280168_().m_252880_(0.0f, 22.0f, 0.0f);
        }
    }
}

