/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.spellcraftgaming.rpghud.gui.GuiButtonTooltip;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;

@Environment(value=EnvType.CLIENT)
public class GuiSliderMod
extends GuiButtonTooltip {
    private static final class_2960 HANDLE_TEXTURE = new class_2960("widget/slider_handle");
    private static final class_2960 HANDLE_HIGHLIGHTED_TEXTURE = new class_2960("widget/slider_handle_highlighted");
    private EnumColor color;
    public double sliderValue = 1.0;
    public String dispString = "";
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    private final float valueStep;
    public int value;
    public ISlider parent = null;
    public String suffix = "";
    public boolean drawString = true;

    private class_2960 getHandleTexture() {
        if (this.field_22762 || this.method_25370()) {
            return HANDLE_HIGHLIGHTED_TEXTURE;
        }
        return HANDLE_TEXTURE;
    }

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, class_4185.class_4241 titleIn) {
        this(color, x, y, value, minValueIn, maxValue, valueStep, null, titleIn);
    }

    public GuiSliderMod(EnumColor color, int x, int y, float value, float minValueIn, float maxValue, float valueStep, ISlider par, class_4185.class_4241 titleIn) {
        super(x, y, 150, 12, (class_2561)class_2561.method_43471((String)""), titleIn);
        this.color = color;
        this.sliderValue = value / 255.0f;
        this.value = (int)Math.ceil(value);
        this.minValue = minValueIn;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        if (this.showDecimal) {
            String val = Double.toString(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            String val = Integer.toString((int)Math.round(this.sliderValue * ((double)maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        if (!this.drawString) {
            this.dispString = "";
        }
    }

    public boolean method_25406(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.dragging = false;
        return super.method_25406(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public int getValue() {
        return (int)Math.ceil(this.value);
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    public void method_25348(double mouseX, double mouseY) {
        this.sliderValue = Math.ceil(class_3532.method_15350((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
        this.updateSlider(mouseX, mouseY);
        this.dragging = true;
    }

    public void updateSlider(double mouseX, double mouseY) {
        this.sliderValue = (float)(mouseX - (double)(this.method_46426() + 4)) / (float)(this.field_22758 - 8);
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        this.value = class_3532.method_15384((double)class_3532.method_15350((double)(this.sliderValue * 255.0), (double)0.0, (double)255.0));
    }

    private String getDisplayString() {
        return "#" + Integer.toHexString(this.getValue()).toUpperCase();
    }

    @Override
    public void method_48579(class_332 dc, int mouseX, int mouseY, float partial) {
        if (this.field_22764) {
            if (this.dragging) {
                this.updateSlider(mouseX, mouseY);
            }
            class_310 mc = class_310.method_1551();
            int color = 0 + (this.color == EnumColor.RED ? this.value << 16 : (this.color == EnumColor.GREEN ? this.value << 8 : this.value));
            HudElement.drawCustomBar(dc, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759, 100.0, color, HudElement.offsetColorPercent(color, 25));
            color = 0xE0E0E0;
            if (!this.field_22763) {
                color = 0xA0A0A0;
            } else if (this.method_49606()) {
                color = 0xFFFFA0;
            }
            String buttonText = this.getDisplayString();
            dc.method_52706(this.getHandleTexture(), this.method_46426() + (int)(this.sliderValue * (double)(this.field_22758 - 8)), this.method_46427(), 8, this.method_25364());
            dc.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            dc.method_25300(mc.field_1772, buttonText, this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, color);
        }
    }

    public float normalizeValue(float value) {
        return (float)class_3532.method_15350((double)(((double)this.snapToStepClamp(value) - this.maxValue) / (this.maxValue - this.minValue)), (double)0.0, (double)1.0);
    }

    public float denormalizeValue(float value) {
        return this.snapToStepClamp((float)(this.minValue + (this.maxValue - this.minValue) * (double)class_3532.method_15363((float)value, (float)0.0f, (float)1.0f)));
    }

    public float snapToStepClamp(float value) {
        value = this.snapToStep(value);
        return (float)class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
    }

    private float snapToStep(float value) {
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EnumColor {
        RED,
        GREEN,
        BLUE;

    }

    @Environment(value=EnvType.CLIENT)
    public static interface ISlider {
        public void onChangeSliderValue(GuiSliderMod var1);
    }
}

