/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;

@Environment(value=EnvType.CLIENT)
public class RenderOverlay
implements HudRenderCallback {
    private ModRPGHud rpgHud = ModRPGHud.instance;
    private class_310 mc = class_310.method_1551();

    public RenderOverlay() {
        HudRenderCallback.EVENT.register((Object)this);
    }

    private void renderOverlay(class_332 dc, float partialTicks) {
        this.drawElement(HudElementType.WIDGET, dc, partialTicks);
        this.drawElement(HudElementType.CLOCK, dc, partialTicks);
        this.drawElement(HudElementType.DETAILS, dc, partialTicks);
        this.drawElement(HudElementType.COMPASS, dc, partialTicks);
        this.drawElement(HudElementType.ENTITY_INSPECT, dc, partialTicks);
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH)) {
            this.drawElement(HudElementType.HEALTH, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.ARMOR)) {
            this.drawElement(HudElementType.ARMOR, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.FOOD)) {
            this.drawElement(HudElementType.FOOD, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH_MOUNT)) {
            this.drawElement(HudElementType.HEALTH_MOUNT, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.AIR)) {
            this.drawElement(HudElementType.AIR, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.JUMP_BAR)) {
            this.drawElement(HudElementType.JUMP_BAR, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.STATUS_EFFECTS)) {
            this.drawElement(HudElementType.STATUS_EFFECTS, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.EXPERIENCE)) {
            this.drawElement(HudElementType.EXPERIENCE, dc, partialTicks);
            this.drawElement(HudElementType.LEVEL, dc, partialTicks);
        }
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HOTBAR)) {
            this.drawElement(HudElementType.HOTBAR, dc, partialTicks);
        }
        this.drawElement(HudElementType.MISC, dc, partialTicks);
    }

    private void drawElement(HudElementType type, class_332 dc, float partialTicks) {
        if (this.rpgHud.getActiveHud().checkElementConditions(type) && !this.preventElementRenderType(type)) {
            dc.method_51448().method_22903();
            RenderSystem.enableBlend();
            this.rpgHud.getActiveHud().drawElement(type, dc, partialTicks, partialTicks, this.mc.method_22683().method_4486(), this.mc.method_22683().method_4502());
            dc.method_51448().method_22909();
        }
    }

    private boolean preventElementRenderType(HudElementType type) {
        String id = "prevent_element_render_" + type.name().toLowerCase();
        if (this.rpgHud.settings.doesSettingExist(id)) {
            return this.rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean shouldRenderVanilla(HudElementType type) {
        return RenderOverlay.isVanillaElement(type) || RenderOverlay.forceRenderTypeVanilla(type);
    }

    public static boolean forceRenderTypeVanilla(HudElementType type) {
        ModRPGHud rpgHud = ModRPGHud.instance;
        String id = "render_vanilla_" + type.name().toLowerCase();
        if (rpgHud.settings.doesSettingExist(id)) {
            return rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean preventEventType(HudElementType type) {
        ModRPGHud rpgHud = ModRPGHud.instance;
        String id = "prevent_event_" + type.name().toLowerCase();
        if (rpgHud.settings.doesSettingExist(id)) {
            return rpgHud.settings.getBoolValue(id);
        }
        return false;
    }

    public static boolean isVanillaElement(HudElementType type) {
        return ModRPGHud.instance.getActiveHud().isVanillaElement(type);
    }

    public void onHudRender(class_332 dc, float tickDelta) {
        this.renderOverlay(dc, tickDelta);
    }
}

