/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.main;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.spellcraftgaming.rpghud.gui.hud.Hud;
import net.spellcraftgaming.rpghud.gui.hud.HudDefault;
import net.spellcraftgaming.rpghud.gui.hud.HudExtendedWidget;
import net.spellcraftgaming.rpghud.gui.hud.HudFullTexture;
import net.spellcraftgaming.rpghud.gui.hud.HudModern;
import net.spellcraftgaming.rpghud.gui.hud.HudSimple;
import net.spellcraftgaming.rpghud.gui.hud.HudVanilla;
import net.spellcraftgaming.rpghud.main.RenderOverlay;
import net.spellcraftgaming.rpghud.settings.Settings;

@Environment(value=EnvType.CLIENT)
public class ModRPGHud
implements ClientModInitializer {
    public final String MODID = "rpg-hud";
    public static ModRPGHud instance;
    public static boolean[] renderDetailsAgain;
    public static int screenOffset;
    public Settings settings;
    public Map<String, Hud> huds = new LinkedHashMap<String, Hud>();

    public void onInitializeClient() {
        instance = this;
        this.settings = new Settings();
        this.registerHud(new HudVanilla(class_310.method_1551(), "vanilla", "Vanilla"));
        this.registerHud(new HudSimple(class_310.method_1551(), "simple", "Simplified"));
        this.registerHud(new HudDefault(class_310.method_1551(), "default", "Default"));
        this.registerHud(new HudExtendedWidget(class_310.method_1551(), "extended", "Extended Widget"));
        this.registerHud(new HudFullTexture(class_310.method_1551(), "texture", "Full Texture"));
        this.registerHud(new HudModern(class_310.method_1551(), "modern", "Modern Style"));
        if (!this.isHudKeyValid(this.settings.getStringValue("hud_type"))) {
            this.settings.setSetting("hud_type", "vanilla");
        }
        new RenderOverlay();
        if (ModRPGHud.isClass("io.github.prospector.modmenu.ModMenu")) {
            screenOffset = 12;
        }
    }

    public void registerHud(Hud hud) {
        this.huds.put(hud.getHudKey(), hud);
    }

    public Hud getActiveHud() {
        return this.huds.get(this.settings.getStringValue("hud_type"));
    }

    public Hud getVanillaHud() {
        return this.huds.get("vanilla");
    }

    public boolean isVanillaHud() {
        return this.settings.getStringValue("hud_type") == "vanilla";
    }

    public boolean isHudKeyValid(String key) {
        return this.huds.containsKey(key);
    }

    public static boolean isClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        renderDetailsAgain = new boolean[]{false, false, false};
        screenOffset = 0;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum HeartTypeNew {
        CONTAINER(class_2960.method_60656((String)"hud/heart/container"), class_2960.method_60656((String)"hud/heart/container_blinking"), class_2960.method_60656((String)"hud/heart/container"), class_2960.method_60656((String)"hud/heart/container_blinking"), class_2960.method_60656((String)"hud/heart/container_hardcore"), class_2960.method_60656((String)"hud/heart/container_hardcore_blinking"), class_2960.method_60656((String)"hud/heart/container_hardcore"), class_2960.method_60656((String)"hud/heart/container_hardcore_blinking")),
        NORMAL(class_2960.method_60656((String)"hud/heart/full"), class_2960.method_60656((String)"hud/heart/full_blinking"), class_2960.method_60656((String)"hud/heart/half"), class_2960.method_60656((String)"hud/heart/half_blinking"), class_2960.method_60656((String)"hud/heart/hardcore_full"), class_2960.method_60656((String)"hud/heart/hardcore_full_blinking"), class_2960.method_60656((String)"hud/heart/hardcore_half"), class_2960.method_60656((String)"hud/heart/hardcore_half_blinking")),
        POISONED(class_2960.method_60656((String)"hud/heart/poisoned_full"), class_2960.method_60656((String)"hud/heart/poisoned_full_blinking"), class_2960.method_60656((String)"hud/heart/poisoned_half"), class_2960.method_60656((String)"hud/heart/poisoned_half_blinking"), class_2960.method_60656((String)"hud/heart/poisoned_hardcore_full"), class_2960.method_60656((String)"hud/heart/poisoned_hardcore_full_blinking"), class_2960.method_60656((String)"hud/heart/poisoned_hardcore_half"), class_2960.method_60656((String)"hud/heart/poisoned_hardcore_half_blinking")),
        WITHERED(class_2960.method_60656((String)"hud/heart/withered_full"), class_2960.method_60656((String)"hud/heart/withered_full_blinking"), class_2960.method_60656((String)"hud/heart/withered_half"), class_2960.method_60656((String)"hud/heart/withered_half_blinking"), class_2960.method_60656((String)"hud/heart/withered_hardcore_full"), class_2960.method_60656((String)"hud/heart/withered_hardcore_full_blinking"), class_2960.method_60656((String)"hud/heart/withered_hardcore_half"), class_2960.method_60656((String)"hud/heart/withered_hardcore_half_blinking")),
        ABSORBING(class_2960.method_60656((String)"hud/heart/absorbing_full"), class_2960.method_60656((String)"hud/heart/absorbing_full_blinking"), class_2960.method_60656((String)"hud/heart/absorbing_half"), class_2960.method_60656((String)"hud/heart/absorbing_half_blinking"), class_2960.method_60656((String)"hud/heart/absorbing_hardcore_full"), class_2960.method_60656((String)"hud/heart/absorbing_hardcore_full_blinking"), class_2960.method_60656((String)"hud/heart/absorbing_hardcore_half"), class_2960.method_60656((String)"hud/heart/absorbing_hardcore_half_blinking")),
        FROZEN(class_2960.method_60656((String)"hud/heart/frozen_full"), class_2960.method_60656((String)"hud/heart/frozen_full_blinking"), class_2960.method_60656((String)"hud/heart/frozen_half"), class_2960.method_60656((String)"hud/heart/frozen_half_blinking"), class_2960.method_60656((String)"hud/heart/frozen_hardcore_full"), class_2960.method_60656((String)"hud/heart/frozen_hardcore_full_blinking"), class_2960.method_60656((String)"hud/heart/frozen_hardcore_half"), class_2960.method_60656((String)"hud/heart/frozen_hardcore_half_blinking"));

        private final class_2960 fullTexture;
        private final class_2960 fullBlinkingTexture;
        private final class_2960 halfTexture;
        private final class_2960 halfBlinkingTexture;
        private final class_2960 hardcoreFullTexture;
        private final class_2960 hardcoreFullBlinkingTexture;
        private final class_2960 hardcoreHalfTexture;
        private final class_2960 hardcoreHalfBlinkingTexture;

        private HeartTypeNew(class_2960 fullTexture, class_2960 fullBlinkingTexture, class_2960 halfTexture, class_2960 halfBlinkingTexture, class_2960 hardcoreFullTexture, class_2960 hardcoreFullBlinkingTexture, class_2960 hardcoreHalfTexture, class_2960 hardcoreHalfBlinkingTexture) {
            this.fullTexture = fullTexture;
            this.fullBlinkingTexture = fullBlinkingTexture;
            this.halfTexture = halfTexture;
            this.halfBlinkingTexture = halfBlinkingTexture;
            this.hardcoreFullTexture = hardcoreFullTexture;
            this.hardcoreFullBlinkingTexture = hardcoreFullBlinkingTexture;
            this.hardcoreHalfTexture = hardcoreHalfTexture;
            this.hardcoreHalfBlinkingTexture = hardcoreHalfBlinkingTexture;
        }

        public class_2960 getTexture(boolean hardcore, boolean half, boolean blinking) {
            if (!hardcore) {
                if (half) {
                    return blinking ? this.halfBlinkingTexture : this.halfTexture;
                }
                return blinking ? this.fullBlinkingTexture : this.fullTexture;
            }
            if (half) {
                return blinking ? this.hardcoreHalfBlinkingTexture : this.hardcoreHalfTexture;
            }
            return blinking ? this.hardcoreFullBlinkingTexture : this.hardcoreFullTexture;
        }

        public static HeartTypeNew fromPlayerState(class_1657 player) {
            HeartTypeNew HeartTypeNew2 = player.method_6059(class_1294.field_5899) ? POISONED : (player.method_6059(class_1294.field_5920) ? WITHERED : (player.method_32314() ? FROZEN : NORMAL));
            return HeartTypeNew2;
        }
    }
}

