/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.mixin;

import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10209;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;
import net.spellcraftgaming.rpghud.main.ModRPGHud;
import net.spellcraftgaming.rpghud.main.RenderOverlay;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public class RenderOverlayMixin {
    private static final class_2960 ARMOR_EMPTY_TEXTURE = class_2960.method_60656((String)"hud/armor_empty");
    private static final class_2960 ARMOR_HALF_TEXTURE = class_2960.method_60656((String)"hud/armor_half");
    private static final class_2960 ARMOR_FULL_TEXTURE = class_2960.method_60656((String)"hud/armor_full");
    private static final class_2960 FOOD_EMPTY_HUNGER_TEXTURE = class_2960.method_60656((String)"hud/food_empty_hunger");
    private static final class_2960 FOOD_HALF_HUNGER_TEXTURE = class_2960.method_60656((String)"hud/food_half_hunger");
    private static final class_2960 FOOD_FULL_HUNGER_TEXTURE = class_2960.method_60656((String)"hud/food_full_hunger");
    private static final class_2960 FOOD_EMPTY_TEXTURE = class_2960.method_60656((String)"hud/food_empty");
    private static final class_2960 FOOD_HALF_TEXTURE = class_2960.method_60656((String)"hud/food_half");
    private static final class_2960 FOOD_FULL_TEXTURE = class_2960.method_60656((String)"hud/food_full");
    private static final class_2960 AIR_TEXTURE = class_2960.method_60656((String)"hud/air");
    private static final class_2960 AIR_BURSTING_TEXTURE = class_2960.method_60656((String)"hud/air_bursting");
    private int lastHealthValue;
    private int renderHealthValue;
    private long lastHealthCheckTime;
    private long heartJumpEndTick;
    private int ticks;

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void tick(CallbackInfo info) {
        ++this.ticks;
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatusBars"}, cancellable=true)
    private void renderStatusBars(class_332 dc, CallbackInfo info) {
        int aa;
        int z;
        int y;
        int x;
        class_310 client = class_310.method_1551();
        int scaledWidth = client.method_22683().method_4486();
        int scaledHeight = client.method_22683().method_4502();
        Random random = new Random();
        class_1657 playerEntity = this.getCameraPlayer();
        if (playerEntity == null) {
            return;
        }
        int i = class_3532.method_15386((float)playerEntity.method_6032());
        boolean bl = this.heartJumpEndTick > (long)this.ticks && (this.heartJumpEndTick - (long)this.ticks) / 3L % 2L == 1L;
        long l = class_156.method_658();
        if (i < this.lastHealthValue && playerEntity.field_6008 > 0) {
            this.lastHealthCheckTime = l;
            this.heartJumpEndTick = this.ticks + 20;
        } else if (i > this.lastHealthValue && playerEntity.field_6008 > 0) {
            this.lastHealthCheckTime = l;
            this.heartJumpEndTick = this.ticks + 10;
        }
        if (l - this.lastHealthCheckTime > 1000L) {
            this.lastHealthValue = i;
            this.renderHealthValue = i;
            this.lastHealthCheckTime = l;
        }
        this.lastHealthValue = i;
        int j = this.renderHealthValue;
        random.setSeed(this.ticks * 312871);
        class_1702 hungerManager = playerEntity.method_7344();
        int k = hungerManager.method_7586();
        int m = scaledWidth / 2 - 91;
        int n = scaledWidth / 2 + 91;
        int o = scaledHeight - 39;
        float f = Math.max((float)playerEntity.method_45325(class_5134.field_23716), (float)Math.max(j, i));
        int p = class_3532.method_15386((float)playerEntity.method_6067());
        int q = class_3532.method_15386((float)((f + (float)p) / 2.0f / 10.0f));
        int r = Math.max(10 - (q - 2), 3);
        int s = o - (q - 1) * r - 10;
        int t = o - 10;
        int u = playerEntity.method_6096();
        int v = -1;
        if (playerEntity.method_6059(class_1294.field_5924)) {
            v = this.ticks % class_3532.method_15386((float)(f + 5.0f));
        }
        if (RenderOverlay.shouldRenderVanilla(HudElementType.ARMOR)) {
            class_10209.method_64146().method_15396("armor");
            for (int w = 0; w < 10; ++w) {
                if (u <= 0) continue;
                x = m + w * 8;
                if (w * 2 + 1 < u) {
                    dc.method_52706(class_1921::method_62277, ARMOR_FULL_TEXTURE, x, s, 9, 9);
                }
                if (w * 2 + 1 == u) {
                    dc.method_52706(class_1921::method_62277, ARMOR_HALF_TEXTURE, x, s, 9, 9);
                }
                if (w * 2 + 1 <= u) continue;
                dc.method_52706(class_1921::method_62277, ARMOR_EMPTY_TEXTURE, x, s, 9, 9);
            }
        }
        if (RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH)) {
            class_10209.method_64146().method_15405("health");
            this.renderHealthBar(dc, random, playerEntity, m, o, r, v, f, i, j, p, bl);
        }
        class_1309 livingEntity = this.getRiddenEntity();
        x = this.getHeartCount(livingEntity);
        if (RenderOverlay.shouldRenderVanilla(HudElementType.FOOD) && x == 0) {
            class_10209.method_64146().method_15405("food");
            for (y = 0; y < 10; ++y) {
                class_2960 identifier3;
                class_2960 identifier2;
                class_2960 identifier;
                z = o;
                if (playerEntity.method_6059(class_1294.field_5903)) {
                    identifier = FOOD_EMPTY_HUNGER_TEXTURE;
                    identifier2 = FOOD_HALF_HUNGER_TEXTURE;
                    identifier3 = FOOD_FULL_HUNGER_TEXTURE;
                } else {
                    identifier = FOOD_EMPTY_TEXTURE;
                    identifier2 = FOOD_HALF_TEXTURE;
                    identifier3 = FOOD_FULL_TEXTURE;
                }
                if (playerEntity.method_7344().method_7589() <= 0.0f && this.ticks % (k * 3 + 1) == 0) {
                    z += random.nextInt(3) - 1;
                }
                aa = n - y * 8 - 9;
                dc.method_52706(class_1921::method_62277, identifier, aa, z, 9, 9);
                if (y * 2 + 1 < k) {
                    dc.method_52706(class_1921::method_62277, identifier3, aa, z, 9, 9);
                }
                if (y * 2 + 1 != k) continue;
                dc.method_52706(class_1921::method_62277, identifier2, aa, z, 9, 9);
            }
            t -= 10;
        }
        if (RenderOverlay.shouldRenderVanilla(HudElementType.AIR)) {
            class_10209.method_64146().method_15405("air");
            y = playerEntity.method_5748();
            z = Math.min(playerEntity.method_5669(), y);
            if (playerEntity.method_5777(class_3486.field_15517) || z < y) {
                int ab = this.getHeartRows(x) - 1;
                t -= ab * 10;
                int ac = class_3532.method_15384((double)((double)(z - 2) * 10.0 / (double)y));
                int ad = class_3532.method_15384((double)((double)z * 10.0 / (double)y)) - ac;
                for (aa = 0; aa < ac + ad; ++aa) {
                    if (aa < ac) {
                        dc.method_52706(class_1921::method_62277, AIR_TEXTURE, n - aa * 8 - 9, t, 9, 9);
                        continue;
                    }
                    dc.method_52706(class_1921::method_62277, AIR_BURSTING_TEXTURE, n - aa * 8 - 9, t, 9, 9);
                }
            }
        }
        class_10209.method_64146().method_15407();
        info.cancel();
    }

    @Inject(at={@At(value="HEAD")}, method={"renderHotbar"}, cancellable=true)
    private void renderHotbar(CallbackInfo info) {
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HOTBAR)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderMountJumpBar"}, cancellable=true)
    private void renderMountJumpBar(CallbackInfo info) {
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.JUMP_BAR)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderExperienceBar"}, cancellable=true)
    private void renderExperienceBar(CallbackInfo info) {
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.EXPERIENCE)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderExperienceLevel"}, cancellable=true)
    private void renderExperienceLevel(CallbackInfo info) {
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.LEVEL)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderMountHealth"}, cancellable=true)
    private void renderMountHealth(CallbackInfo info) {
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.HEALTH_MOUNT)) {
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderStatusEffectOverlay"}, cancellable=true)
    private void renderStatusEffectOverlay(CallbackInfo info) {
        if (!RenderOverlay.shouldRenderVanilla(HudElementType.STATUS_EFFECTS)) {
            info.cancel();
        }
    }

    private int getHeartCount(class_1309 entity) {
        if (entity != null && entity.method_5709()) {
            float f = entity.method_6063();
            int i = (int)(f + 0.5f) / 2;
            if (i > 30) {
                i = 30;
            }
            return i;
        }
        return 0;
    }

    private int getHeartRows(int heartCount) {
        return (int)Math.ceil((double)heartCount / 10.0);
    }

    private class_1657 getCameraPlayer() {
        class_310 client = class_310.method_1551();
        return !(client.method_1560() instanceof class_1657) ? null : (class_1657)client.method_1560();
    }

    private class_1309 getRiddenEntity() {
        class_1657 playerEntity = this.getCameraPlayer();
        if (playerEntity != null) {
            class_1297 entity = playerEntity.method_5854();
            if (entity == null) {
                return null;
            }
            if (entity instanceof class_1309) {
                return (class_1309)entity;
            }
        }
        return null;
    }

    private void renderHealthBar(class_332 context, Random random, class_1657 player, int x, int y, int lines, int regeneratingHeartIndex, float maxHealth, int lastHealth, int health, int absorption, boolean blinking) {
        ModRPGHud.HeartTypeNew HeartTypeNew2 = ModRPGHud.HeartTypeNew.fromPlayerState(player);
        boolean bl = player.method_37908().method_8401().method_152();
        int i = class_3532.method_15384((double)((double)maxHealth / 2.0));
        int j = class_3532.method_15384((double)((double)absorption / 2.0));
        int k = i * 2;
        for (int l = i + j - 1; l >= 0; --l) {
            boolean bl4;
            int r;
            boolean bl2;
            int m = l / 10;
            int n = l % 10;
            int o = x + n * 8;
            int p = y - m * lines;
            if (lastHealth + absorption <= 4) {
                p += random.nextInt(2);
            }
            if (l < i && l == regeneratingHeartIndex) {
                p -= 2;
            }
            this.drawHeart(context, ModRPGHud.HeartTypeNew.CONTAINER, o, p, bl, blinking, false);
            int q = l * 2;
            boolean bl3 = bl2 = l >= i;
            if (bl2 && (r = q - k) < absorption) {
                boolean bl32 = r + 1 == absorption;
                this.drawHeart(context, HeartTypeNew2 == ModRPGHud.HeartTypeNew.WITHERED ? HeartTypeNew2 : ModRPGHud.HeartTypeNew.ABSORBING, o, p, bl, false, bl32);
            }
            if (blinking && q < health) {
                bl4 = q + 1 == health;
                this.drawHeart(context, HeartTypeNew2, o, p, bl, true, bl4);
            }
            if (q >= lastHealth) continue;
            bl4 = q + 1 == lastHealth;
            this.drawHeart(context, HeartTypeNew2, o, p, bl, false, bl4);
        }
    }

    private void drawHeart(class_332 context, ModRPGHud.HeartTypeNew type, int x, int y, boolean hardcore, boolean blinking, boolean half) {
        context.method_52706(class_1921::method_62277, type.getTexture(hardcore, half, blinking), x, y, 9, 9);
    }
}

