/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.ModSoundList;
import com.mgen256.al.PedestalTypes;
import com.mgen256.al.blocks.ModBlock;
import com.mgen256.al.blocks.Pedestal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class FireBase
extends ModBlock {
    public static BooleanProperty SET = BooleanProperty.func_177716_a((String)"set");
    public static BooleanProperty SUMMONED = BooleanProperty.func_177716_a((String)"summoned");
    public static BooleanProperty TEMP = BooleanProperty.func_177716_a((String)"temp");
    private static Map<PedestalTypes, VoxelShape> SHAPES;
    private static Map<PedestalTypes, BasicParticleType> PARTICLE_TYPES;
    private static Map<PedestalTypes, Double> SMOKE_POS;
    private static final VoxelShape COLLISION_SHAPE;
    private PedestalTypes pedestalKey;

    protected static AbstractBlock.Properties createProps(MaterialColor mapColor) {
        return AbstractBlock.Properties.func_200949_a((Material)Material.field_151594_q, (MaterialColor)mapColor).func_200943_b(0.0f).func_200942_a().func_200947_a(new SoundType(1.5f, 1.0f, AdditionalLights.modSounds.get((Object)ModSoundList.Fire_Extinguish), SoundEvents.field_187554_ai, SoundEvents.field_187845_fY, SoundEvents.field_187550_ag, SoundEvents.field_187548_af));
    }

    public FireBase(String basename, PedestalTypes _pedestalKey, AbstractBlock.Properties props) {
        super(basename + (Object)((Object)_pedestalKey), null, props, SHAPES.get((Object)_pedestalKey));
        this.pedestalKey = _pedestalKey;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SET, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SUMMONED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TEMP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SET});
        builder.func_206894_a(new Property[]{SUMMONED});
        builder.func_206894_a(new Property[]{TEMP});
    }

    protected float getFireDamageAmount() {
        return 0.0f;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    public void setRenderLayer() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228643_e_());
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES.get((Object)this.pedestalKey);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + SMOKE_POS.get((Object)this.pedestalKey);
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_195594_a((IParticleData)PARTICLE_TYPES.get((Object)this.pedestalKey), d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (!((Boolean)state.func_177229_b((Property)SUMMONED)).booleanValue() && !((Boolean)state.func_177229_b((Property)TEMP)).booleanValue()) {
            return super.func_220076_a((BlockState)state.func_206870_a((Property)SET, (Comparable)Boolean.valueOf(false)), builder);
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        return list;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Block lowerblock = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!(lowerblock instanceof Pedestal)) {
            return;
        }
        Pedestal pedestal = (Pedestal)lowerblock;
        if (pedestal.getType() == this.pedestalKey) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)SET, (Comparable)Boolean.valueOf(true)));
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    static {
        COLLISION_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0);
        SHAPES = new LinkedHashMap<PedestalTypes, VoxelShape>();
        SHAPES.put(PedestalTypes.standing_torch_s, Block.func_208617_a((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0));
        SHAPES.put(PedestalTypes.standing_torch_l, Block.func_208617_a((double)4.0, (double)-2.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0));
        SHAPES.put(PedestalTypes.fire_pit_s, Block.func_208617_a((double)0.0, (double)-10.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0));
        SHAPES.put(PedestalTypes.fire_pit_l, Block.func_208617_a((double)0.0, (double)-2.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0));
        PARTICLE_TYPES = new LinkedHashMap<PedestalTypes, BasicParticleType>();
        PARTICLE_TYPES.put(PedestalTypes.standing_torch_s, ParticleTypes.field_197601_L);
        PARTICLE_TYPES.put(PedestalTypes.standing_torch_l, ParticleTypes.field_197601_L);
        PARTICLE_TYPES.put(PedestalTypes.fire_pit_s, ParticleTypes.field_197594_E);
        PARTICLE_TYPES.put(PedestalTypes.fire_pit_l, ParticleTypes.field_197594_E);
        SMOKE_POS = new LinkedHashMap<PedestalTypes, Double>();
        SMOKE_POS.put(PedestalTypes.standing_torch_s, 0.2);
        SMOKE_POS.put(PedestalTypes.standing_torch_l, 0.7);
        SMOKE_POS.put(PedestalTypes.fire_pit_s, 0.0);
        SMOKE_POS.put(PedestalTypes.fire_pit_l, 0.8);
    }
}

