/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adfinders.finder;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adfinders.finder.Arrows;
import com.endertech.minecraft.mods.adfinders.finder.FinderState;
import com.endertech.minecraft.mods.adfinders.finder.Needle;
import com.endertech.minecraft.mods.adfinders.items.Finder;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.apache.commons.lang3.ArrayUtils;

@OnlyIn(value=Dist.CLIENT)
public class Renderer
extends ItemStackTileEntityRenderer {
    public static final RenderType RENDER_TYPE = RenderType.func_228644_e_((ResourceLocation)GameRendering.EMPTY_TEXTURE);

    public void func_239207_a_(ItemStack itemStack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, int combinedLight, int combinedOverlay) {
        this.renderModel(itemStack, matrixStack, renderBuffer, combinedLight, combinedOverlay);
        this.renderIndicators(itemStack, matrixStack, renderBuffer);
    }

    ItemRenderer getItemRenderer() {
        return Minecraft.func_71410_x().func_175599_af();
    }

    void renderIndicators(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer) {
        FinderState state = Finder.findStateFor(stack);
        if (state == null) {
            return;
        }
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227861_a_(0.0, 0.0, (double)-0.04f);
        Entity carrier = state.getCarrier();
        Vect3d startPos = ForgeEntity.getCenterPosition((Entity)carrier);
        float rotationYaw = carrier.field_70177_z;
        if (carrier instanceof LivingEntity) {
            Minecraft mc = Minecraft.func_71410_x();
            if (carrier != mc.field_71439_g || mc.field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) {
                rotationYaw = ((LivingEntity)carrier).field_70761_aq;
            }
        }
        IVertexBuilder builder = buffer.getBuffer(RENDER_TYPE);
        float offset = 0.0f;
        for (Arrows.Arrow arrow : state.getArrows().values()) {
            if (arrow == null) continue;
            matrix.func_227861_a_(0.0, 0.0, (double)offset);
            arrow.draw(builder, matrix, 1.0f);
            matrix.func_227861_a_(0.0, 0.0, (double)(-offset));
        }
        offset = 0.001f;
        matrix.func_227861_a_(0.0, 0.0, (double)offset);
        for (Needle needle : state.getNeedles()) {
            CommonMath.Angle angle = needle.getAngle(startPos, rotationYaw);
            matrix.func_227861_a_(0.0, 0.0, (double)offset);
            needle.draw(builder, matrix, angle, 1.0f);
            matrix.func_227861_a_(0.0, 0.0, (double)(-offset));
            offset += 0.001f;
        }
        matrix.func_227865_b_();
    }

    void renderModel(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        RenderType rendertype = RenderTypeLookup.func_239219_a_((ItemStack)stack, (boolean)true);
        IBakedModel model = this.getItemRenderer().func_184393_a(stack, null, null);
        IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.func_77962_s());
        Random random = new Random(42L);
        for (Direction direction : (Direction[])ArrayUtils.add((Object[])Direction.values(), null)) {
            this.getItemRenderer().func_229112_a_(matrix, builder, model.getQuads(null, direction, random, (IModelData)EmptyModelData.INSTANCE), stack, combinedLight, combinedOverlay);
        }
    }
}

