/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.client.GameKeys;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="forgeendertech", value={Dist.CLIENT})
public class DevInfo {
    static final GameTime UPDATE_INTERVAL = GameTime.quaterSecond();
    static final GameTime EXCEPTION_PRINT_INTERVAL = GameTime.seconds(10);
    protected static float rayTraceDistance = 10.0f;
    protected static boolean showInventoryTooltip = false;
    protected static boolean renderGameOverlay = false;
    protected static boolean hotKeyWasDown = false;
    private static RayTraceResult rayTraceResult = null;

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (ForgeEndertech.isDebugMode() && Minecraft.func_71410_x().field_71441_e != null) {
            int hotKey = 281;
            if (GameKeys.isDown(281)) {
                if (!hotKeyWasDown && GameKeys.isShiftDown()) {
                    showInventoryTooltip = !showInventoryTooltip;
                    renderGameOverlay = !renderGameOverlay;
                }
                hotKeyWasDown = true;
            } else {
                hotKeyWasDown = false;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        if (!showInventoryTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b()) {
            List lines = event.getToolTip();
            DevInfo.addItemInfo(stack, lines);
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        block11: {
            if (!renderGameOverlay) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            GameSettings gs = GameKeys.getGameSettings();
            if (mc.field_71462_r == null && event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
                try {
                    boolean shouldRecalcTraceResult;
                    ArrayList<ITextComponent> lines = new ArrayList<ITextComponent>();
                    DevInfo.addWorldInfo(mc.field_71441_e, lines);
                    lines.add((ITextComponent)new StringTextComponent(""));
                    boolean bl = shouldRecalcTraceResult = rayTraceResult == null || UPDATE_INTERVAL.pastIn((World)mc.field_71441_e);
                    if (shouldRecalcTraceResult) {
                        rayTraceResult = gs.field_151444_V.func_151470_d() ? mc.field_71476_x : ForgeEntity.rayTraceBlockBeingLookedAt((Entity)mc.field_71439_g, event.getPartialTicks(), rayTraceDistance);
                    }
                    if (rayTraceResult != null) {
                        switch (rayTraceResult.func_216346_c()) {
                            case BLOCK: {
                                if (!(rayTraceResult instanceof BlockRayTraceResult)) break;
                                DevInfo.addBlockInfo(mc.field_71441_e, ((BlockRayTraceResult)rayTraceResult).func_216350_a(), lines);
                                break;
                            }
                            case ENTITY: {
                                if (!(rayTraceResult instanceof EntityRayTraceResult)) break;
                                DevInfo.addEntityInfo(((EntityRayTraceResult)rayTraceResult).func_216348_a(), lines);
                                break;
                            }
                        }
                    }
                    MatrixStack matrix = event.getMatrixStack();
                    matrix.func_227860_a_();
                    int color = -2130706433;
                    int x = 2;
                    int y = 2;
                    int step = 10;
                    for (ITextComponent line : lines) {
                        mc.field_71466_p.func_238405_a_(matrix, line.getString(), (float)x, (float)y, color);
                        y += step;
                    }
                    GL11.glPopMatrix();
                }
                catch (Exception e) {
                    if (!EXCEPTION_PRINT_INTERVAL.pastIn((World)mc.field_71441_e)) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void addCaptionLine(List<ITextComponent> lines, String caption) {
        lines.add((ITextComponent)new StringTextComponent("==" + caption + "=="));
    }

    protected static void addInfoLine(List<ITextComponent> lines, String caption, Object value) {
        lines.add((ITextComponent)DevInfo.underlined(caption + ": ").func_240702_b_(String.valueOf(value)));
    }

    protected static void addWorldInfo(ClientWorld world, List<ITextComponent> lines) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        BlockPos pos = player.func_233580_cy_();
        Biome biome = world.func_226691_t_(pos);
        GameWorld.WorldData data = GameWorld.getData((IWorld)world);
        IWind wind = GameWorld.getWindAt((World)world, pos);
        DevInfo.addCaptionLine(lines, "World Info");
        DevInfo.addInfoLine(lines, "Biome", biome.toString());
        DevInfo.addInfoLine(lines, "Wind", Float.valueOf(wind.getStrengthIn(player.func_174811_aO())));
        DevInfo.addInfoLine(lines, "isRaining", world.func_72896_J());
        DevInfo.addInfoLine(lines, "Strength", "rain = " + world.field_73004_o + ", thunder = " + world.field_73017_q);
        DevInfo.addInfoLine(lines, "SmokeParticles", data.smokeParticlesCount);
        DevInfo.addInfoLine(lines, "Time", world.func_72820_D());
    }

    protected static void addBlockInfo(ClientWorld world, BlockPos pos, List<ITextComponent> lines) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        UnitId id = UnitId.from(state);
        DevInfo.addCaptionLine(lines, "Block Info");
        lines.add((ITextComponent)DevInfo.formatedId(id));
        DevInfo.addInfoLine(lines, "State", state);
        DevInfo.addInfoLine(lines, "StateId", Block.func_196246_j((BlockState)state));
        DevInfo.addInfoLine(lines, "RegistryName", block.getRegistryName());
        DevInfo.addInfoLine(lines, "TranslationKey", block.func_149739_a());
        DevInfo.addInfoLine(lines, "Hardness", Float.valueOf(state.func_185887_b((IBlockReader)world, pos)));
        DevInfo.addInfoLine(lines, "Resistance", Float.valueOf(state.getExplosionResistance((IBlockReader)world, pos, null)));
        DevInfo.addInfoLine(lines, "Harvest level", state.getHarvestLevel());
        DevInfo.addInfoLine(lines, "Opacity", state.func_200016_a((IBlockReader)world, pos));
        DevInfo.addInfoLine(lines, "CanSeeSky", ForgeBlock.isUnderOpenSky((World)world, pos));
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeBlock.isUnderRain((World)world, pos));
        DevInfo.addInfoLine(lines, "PrecipitationHeight", world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, pos).func_177956_o());
        DevInfo.addInfoLine(lines, "BlockPos", Args.join(Args.get("x", pos.func_177958_n()), Args.get("y", pos.func_177956_o()), Args.get("z", pos.func_177952_p())));
        DevInfo.addInfoLine(lines, "Shape", state.func_196954_c((IBlockReader)world, pos));
        if (rayTraceResult instanceof BlockRayTraceResult) {
            Direction face = ((BlockRayTraceResult)rayTraceResult).func_216354_b();
            DevInfo.addInfoLine(lines, "Face", face);
        }
        DevInfo.addInfoLine(lines, "CollisionShape", state.func_196952_d((IBlockReader)world, pos));
        DevInfo.addInfoLine(lines, "TileEntity", world.func_175625_s(pos));
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            DevInfo.addCompoundInfo(tile.func_189515_b(new CompoundNBT()), lines);
        }
    }

    static void addEntityInfo(Entity entity, List<ITextComponent> lines) {
        DevInfo.addCaptionLine(lines, "Entity Info");
        DevInfo.addInfoLine(lines, "id", ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entity.func_200600_R()));
        DevInfo.addInfoLine(lines, "name", entity.func_200200_C_());
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeEntity.isUnderRain(entity));
        DevInfo.addCompoundInfo(entity.func_189511_e(new CompoundNBT()), lines);
    }

    protected static void addItemInfo(ItemStack stack, List<ITextComponent> lines) {
        Item item = stack.func_77973_b();
        UnitId unitId = UnitId.from(stack.func_77973_b());
        DevInfo.addInfoLine(lines, "Durability", stack.func_77958_k());
        lines.add((ITextComponent)DevInfo.formatedId(unitId));
        DevInfo.addInfoLine(lines, "BurnTime", stack.getBurnTime());
        DevInfo.addInfoLine(lines, "Group", Optional.ofNullable(item.func_77640_w()).map(group -> group.func_200300_c()).orElse("none"));
        DevInfo.addCompoundInfo(stack.func_77978_p(), lines);
    }

    protected static void addCompoundInfo(CompoundNBT compound, List<ITextComponent> lines) {
        if (compound != null) {
            lines.add((ITextComponent)DevInfo.underlined("NBT: "));
            for (String key : compound.func_150296_c()) {
                ForgeNBT.Types type = ForgeNBT.getType(compound, key);
                String line = type.toString() + " " + key;
                if (type.isOrdinal() || type == ForgeNBT.Types.STRING) {
                    line = line + " = " + compound.func_74781_a(key);
                }
                lines.add((ITextComponent)new StringTextComponent(line).func_240699_a_(TextFormatting.RESET));
            }
        } else {
            lines.add((ITextComponent)new StringTextComponent("no NBT"));
        }
    }

    protected static IFormattableTextComponent underlined(String string) {
        return new StringTextComponent(string).func_240699_a_(TextFormatting.UNDERLINE);
    }

    protected static TextFormatting reset() {
        return TextFormatting.RESET;
    }

    protected static IFormattableTextComponent formatedId(UnitId id) {
        return DevInfo.underlined("ID: ").func_240702_b_(id.toString());
    }
}

