function initializeCoreMod() {
    Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/block/CampfireBlock',
		'methodName' : resolveName('func_220098_a'), // spawnSmokeParticles
		'methodDesc' : '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;ZZ)V'
	}
	
	var handler = {
		'class': 'com/endertech/minecraft/forge/events/CampfireSmokeEvent',
		'methodName': 'onCampfireSmokeSpawn',
		'methodDesc': '(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;ZZ)Z'
	}

    var instructions = [
		insnLoadObj(0, "world"),
		insnLoadObj(1, "pos"),
		insnLoadInt(2, "isSignalFire"),
		insnLoadInt(3, "spawnExtraSmoke"),
	];
    
	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions.concat(insnCallHandler(handler), instructionsIfTrueReturn()));
				return method;
			}
		}
	}
}