/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.core.ForgeMod;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Tooltip {
    private final ResourceLocation name;
    private final List<ITextComponent> lines;

    public Tooltip(ResourceLocation name, List<ITextComponent> lines) {
        this.name = name;
        this.lines = lines;
    }

    public static Tooltip of(ForgeMod mod, String name, List<ITextComponent> lines) {
        return new Tooltip(mod.toResLoc(name), lines);
    }

    protected String expandLangKey(String langKey) {
        return Args.joinDelim(".", "tooltip", this.name.func_110624_b(), this.name.func_110623_a(), langKey);
    }

    public Tooltip add(TextFormatting textFormat, String langKey) {
        return this.add(textFormat, langKey, null);
    }

    public Tooltip add(TextFormatting textFormat, String langKey, @Nullable Object value) {
        String key = this.expandLangKey(langKey);
        String postfix = value != null ? ": " + value : "";
        this.lines.add((ITextComponent)new StringTextComponent(textFormat + I18n.func_135052_a((String)key, (Object[])new Object[0]) + postfix));
        return this;
    }

    public Tooltip add(String langKey, Object ... parameters) {
        this.lines.add((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)this.expandLangKey(langKey), (Object[])parameters)));
        return this;
    }

    public String button(String langKey, KeyBinding button) {
        String action = langKey.isEmpty() ? "" : I18n.func_135052_a((String)this.expandLangKey(langKey), (Object[])new Object[0]) + " ";
        return action + button.func_238171_j_().getString();
    }
}

