/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.compat.ct;

import com.blamejared.crafttweaker.api.actions.IUndoableAction;
import com.shynieke.ageingmobs.registry.AgeingRegistry;
import com.shynieke.ageingmobs.registry.ageing.AgeingData;

public class ActionRemoveAgeing
implements IUndoableAction {
    public final AgeingData ageingData;
    public final AgeingData oldAgeingData;

    public ActionRemoveAgeing(String ageingID) {
        this.oldAgeingData = this.ageingData = AgeingRegistry.INSTANCE.getNameToAgeing().get(ageingID);
    }

    public void apply() {
        if (this.ageingData != null) {
            AgeingRegistry.INSTANCE.removeAgeing(this.ageingData);
        }
    }

    public String describe() {
        if (this.ageingData != null) {
            return String.format("Ageing from <" + this.ageingData.getEntity().getRegistryName() + "> to <" + this.ageingData.getTransformedEntity().getRegistryName() + "> has been removed with unique ID: " + this.ageingData.getName(), new Object[0]);
        }
        return String.format("Ageing from <" + this.ageingData.getEntity().getRegistryName() + "> to <" + this.ageingData.getTransformedEntity().getRegistryName() + "> could not be removed, ID: " + this.ageingData.getName() + " doesn't exists", new Object[0]);
    }

    public void undo() {
        if (this.oldAgeingData != null) {
            AgeingRegistry.INSTANCE.registerAgeing(this.oldAgeingData);
        }
    }

    public String describeUndo() {
        return String.format("Ageing from <" + this.oldAgeingData.getEntity().getRegistryName() + "> to <" + this.oldAgeingData.getTransformedEntity().getRegistryName() + "> has been re-added, unique ID: " + this.oldAgeingData.getName(), new Object[0]);
    }
}

