/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.ageingmobs.registry.ageing.criteria;

import com.shynieke.ageingmobs.registry.ageing.criteria.BaseCriteria;
import com.shynieke.ageingmobs.registry.ageing.iAgeing;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LightCriteria
extends BaseCriteria {
    private int lightLevelMin;
    private int lightLevelMax;
    private boolean aloneBased;
    private boolean reversible;
    private boolean isReversing;

    public LightCriteria(iAgeing ageing, int lightLevelMin, int lightLevelMax, boolean aloneBased, boolean reversible) {
        super(ageing);
        this.lightLevelMin = lightLevelMin;
        this.lightLevelMax = lightLevelMax;
        this.aloneBased = aloneBased;
        this.reversible = reversible;
        this.isReversing = false;
    }

    public int getLightLevelMin() {
        return this.lightLevelMin;
    }

    public void setLightLevelMin(int lightLevelMin) {
        this.lightLevelMin = lightLevelMin;
    }

    public int getLightLevelMax() {
        return this.lightLevelMax;
    }

    public void setLightLevelMax(int lightLevelMax) {
        this.lightLevelMax = lightLevelMax;
    }

    public boolean isAloneBased() {
        return this.aloneBased;
    }

    public void setAloneBased(boolean aloneBased) {
        this.aloneBased = aloneBased;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    @Override
    public boolean checkCriteria(World worldIn, Entity entityIn) {
        BlockPos entityPos = entityIn.func_180425_c();
        int entityLight = worldIn.func_201696_r(entityPos);
        if (entityLight >= this.getLightLevelMin() && entityLight <= this.getLightLevelMax()) {
            if (this.isAloneBased()) {
                AxisAlignedBB areaHitbox = new AxisAlignedBB((double)((float)entityPos.func_177958_n() - 0.5f), (double)((float)entityPos.func_177956_o() - 0.5f), (double)((float)entityPos.func_177952_p() - 0.5f), (double)((float)entityPos.func_177958_n() + 0.5f), (double)((float)entityPos.func_177956_o() + 0.5f), (double)((float)entityPos.func_177952_p() + 0.5f)).func_72321_a(-5.0, -5.0, -5.0).func_72321_a(5.0, 5.0, 5.0);
                if (!worldIn.func_217357_a(entityIn.getClass(), areaHitbox).contains(this.getEntity().func_200721_a(worldIn))) {
                    this.isReversing = false;
                    return true;
                }
                if (this.isReversible()) {
                    this.isReversing = true;
                }
                return false;
            }
            this.isReversing = false;
            return true;
        }
        if (this.isReversible()) {
            this.isReversing = true;
        }
        return false;
    }

    @Override
    public boolean isReversing() {
        return this.isReversing;
    }
}

